/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.groovy;

import groovy.lang.Closure;
import io.cucumber.core.exception.CucumberException;
import io.cucumber.groovy.GroovyBackend;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public class Hooks {
    private static final int DEFAULT_ORDER = 1000;

    public static void World(Closure body) {
        GroovyBackend.getInstance().registerWorld(body);
    }

    public static void Before(Object ... args) {
        Hooks.addHook(args, true, false);
    }

    public static void After(Object ... args) {
        Hooks.addHook(args, false, false);
    }

    public static void AfterStep(Object ... args) {
        Hooks.addHook(args, false, true);
    }

    public static void BeforeStep(Object ... args) {
        Hooks.addHook(args, true, true);
    }

    private static void addHook(Object[] tagsExpressionsAndBody, boolean before, boolean forStep) {
        int order = 1000;
        boolean orderSet = false;
        Closure body = null;
        String tagExpressions = "";
        for (Object o : tagsExpressionsAndBody) {
            if (o instanceof String) {
                tagExpressions = (String)o;
                continue;
            }
            if (o instanceof Integer) {
                if (orderSet) {
                    throw new CucumberException("Two order (Integer) arguments found; " + order + ", and; " + o);
                }
                order = (Integer)o;
                orderSet = true;
                continue;
            }
            if (o instanceof Closure) {
                body = (Closure)o;
                continue;
            }
            throw new CucumberException("An argument of the type " + o.getClass().getName() + " found, " + (before ? "Before" : "After") + " only allows the argument types String - Tag, Integer - order, and Closure");
        }
        if (before) {
            if (forStep) {
                GroovyBackend.getInstance().addBeforeStepHook(tagExpressions, order, body);
            } else {
                GroovyBackend.getInstance().addBeforeHook(tagExpressions, order, body);
            }
        } else if (forStep) {
            GroovyBackend.getInstance().addAfterStepHook(tagExpressions, order, body);
        } else {
            GroovyBackend.getInstance().addAfterHook(tagExpressions, order, body);
        }
    }
}

