/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.groovy;

import io.cucumber.core.backend.CucumberBackendException;
import io.cucumber.groovy.MethodFormat;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

final class InvalidMethodSignatureException
extends CucumberBackendException {
    private InvalidMethodSignatureException(String message) {
        super(message);
    }

    static InvalidMethodSignatureExceptionBuilder builder(Method method) {
        return new InvalidMethodSignatureExceptionBuilder(method);
    }

    static class InvalidMethodSignatureExceptionBuilder {
        private final Method method;
        private final List<Class<?>> annotations = new ArrayList();
        private final List<String> signatures = new ArrayList<String>();
        private final List<String> notes = new ArrayList<String>();

        private InvalidMethodSignatureExceptionBuilder(Method method) {
            this.method = Objects.requireNonNull(method);
        }

        InvalidMethodSignatureExceptionBuilder addAnnotation(Class<?> annotation) {
            this.annotations.add(annotation);
            return this;
        }

        InvalidMethodSignatureExceptionBuilder addSignature(String signature) {
            this.signatures.add(signature);
            return this;
        }

        InvalidMethodSignatureExceptionBuilder addNote(String note) {
            this.notes.add(note);
            return this;
        }

        public InvalidMethodSignatureException build() {
            return new InvalidMethodSignatureException("" + this.describeAnnotations() + " must have one of these signatures:\n * " + this.describeAvailableSignature() + "\nat " + this.describeLocation() + "\n" + this.describeNote() + "\n");
        }

        private String describeNote() {
            return String.join((CharSequence)"\n", this.notes);
        }

        private Object describeLocation() {
            return MethodFormat.FULL.format(this.method);
        }

        private String describeAvailableSignature() {
            return String.join((CharSequence)"\n * ", this.signatures);
        }

        private String describeAnnotations() {
            if (this.annotations.size() == 1) {
                return "A @" + this.annotations.get(0).getSimpleName() + " annotated method";
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.annotations.size(); ++i) {
                builder.append(this.annotations.get(i).getSimpleName());
                if (i < this.annotations.size() - 2) {
                    builder.append(", ");
                    continue;
                }
                if (i >= this.annotations.size() - 1) continue;
                builder.append(" or ");
            }
            return "A method annotated with " + builder.toString();
        }
    }
}

