/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.groovy;

import groovy.lang.Closure;
import io.cucumber.core.backend.CucumberBackendException;
import io.cucumber.core.backend.CucumberInvocationTargetException;
import io.cucumber.core.backend.Located;
import io.cucumber.groovy.GroovyBackend;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.codehaus.groovy.runtime.InvokerInvocationException;

public class Invoker {
    static void invoke(GroovyBackend backend, Closure body, Object[] args) throws CucumberBackendException {
        body.setResolveStrategy(1);
        body.setDelegate((Object)backend.getGroovyWorld());
        try {
            body.call(args);
        }
        catch (InvokerInvocationException e) {
            throw new CucumberInvocationTargetException(null, new InvocationTargetException(e.getCause()));
        }
    }

    static Object invoke(Located located, Object target, Method method, Object ... args) {
        Method targetMethod = Invoker.targetMethod(target, method);
        boolean accessible = targetMethod.isAccessible();
        try {
            targetMethod.setAccessible(true);
            Object object = targetMethod.invoke(target, args);
            return object;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new CucumberBackendException("Failed to invoke " + targetMethod, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            if (located == null) {
                throw new CucumberBackendException("Failed to invoke " + targetMethod, (Throwable)e);
            }
            throw new CucumberInvocationTargetException(located, e);
        }
        finally {
            targetMethod.setAccessible(accessible);
        }
    }

    private static Method targetMethod(Object target, Method method) {
        Class<?> targetClass = target.getClass();
        Class<?> declaringClass = method.getDeclaringClass();
        if (targetClass.getClassLoader().equals(declaringClass.getClassLoader())) {
            return method;
        }
        try {
            if (Modifier.isPublic(method.getModifiers())) {
                return targetClass.getMethod(method.getName(), method.getParameterTypes());
            }
            for (Class<?> currentClass = targetClass; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                try {
                    return currentClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
            }
            throw new NoSuchMethodException(String.valueOf(method));
        }
        catch (NoSuchMethodException e) {
            throw new CucumberBackendException("Could not find target method", (Throwable)e);
        }
    }
}

