/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.groovy;

import io.cucumber.groovy.DataTableType;
import io.cucumber.groovy.DefaultDataTableCellTransformer;
import io.cucumber.groovy.DefaultDataTableEntryTransformer;
import io.cucumber.groovy.DefaultParameterTransformer;
import io.cucumber.groovy.DocStringType;
import io.cucumber.groovy.InvalidMethodException;
import io.cucumber.groovy.ParameterType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.BiConsumer;

final class MethodScanner {
    private MethodScanner() {
    }

    static void scan(Class<?> aClass, BiConsumer<Method, Annotation> consumer) {
        if (Object.class.equals(aClass)) {
            return;
        }
        if (!MethodScanner.isInstantiable(aClass)) {
            return;
        }
        for (Method method : aClass.getMethods()) {
            MethodScanner.scan(consumer, aClass, method);
        }
    }

    private static boolean isInstantiable(Class<?> clazz) {
        boolean isNonStaticInnerClass = !Modifier.isStatic(clazz.getModifiers()) && clazz.getEnclosingClass() != null;
        return Modifier.isPublic(clazz.getModifiers()) && !Modifier.isAbstract(clazz.getModifiers()) && !isNonStaticInnerClass;
    }

    private static void scan(BiConsumer<Method, Annotation> consumer, Class<?> aClass, Method method) {
        if (Object.class.equals(method.getDeclaringClass())) {
            return;
        }
        MethodScanner.scan(consumer, aClass, method, method.getAnnotations());
    }

    private static void scan(BiConsumer<Method, Annotation> consumer, Class<?> aClass, Method method, Annotation[] methodAnnotations) {
        for (Annotation annotation : methodAnnotations) {
            if (!MethodScanner.isTypeAnnotation(annotation)) continue;
            MethodScanner.validateMethod(aClass, method);
            consumer.accept(method, annotation);
        }
    }

    private static void validateMethod(Class<?> glueCodeClass, Method method) {
        if (!glueCodeClass.equals(method.getDeclaringClass())) {
            throw InvalidMethodException.createInvalidMethodException(method, glueCodeClass);
        }
    }

    private static boolean isTypeAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        return annotationClass.equals(ParameterType.class) || annotationClass.equals(DataTableType.class) || annotationClass.equals(DefaultParameterTransformer.class) || annotationClass.equals(DefaultDataTableEntryTransformer.class) || annotationClass.equals(DefaultDataTableCellTransformer.class) || annotationClass.equals(DocStringType.class);
    }
}

