/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.groovy;

import io.cucumber.core.resource.ClasspathSupport;
import java.io.File;
import java.net.URI;
import java.util.Locale;
import java.util.Objects;

public class ScriptPath {
    private ScriptPath() {
    }

    public static URI parse(String scriptIdentifier) {
        Objects.requireNonNull(scriptIdentifier, "scriptIdentifier may not be null");
        if (scriptIdentifier.isEmpty()) {
            throw new IllegalArgumentException("scriptIdentifier may not be empty");
        }
        if ("classpath:".equals(scriptIdentifier)) {
            return ClasspathSupport.rootPackageUri();
        }
        if (ScriptPath.nonStandardPathSeparatorInUse(scriptIdentifier)) {
            String standardized = ScriptPath.replaceNonStandardPathSeparator(scriptIdentifier);
            return ScriptPath.parseAssumeFileScheme(standardized);
        }
        if (ScriptPath.isWindowsOS() && ScriptPath.pathContainsWindowsDrivePattern(scriptIdentifier)) {
            return ScriptPath.parseAssumeFileScheme(scriptIdentifier);
        }
        return ScriptPath.probablyURI(scriptIdentifier) ? ScriptPath.parseProbableURI(scriptIdentifier) : ScriptPath.parseAssumeFileScheme(scriptIdentifier);
    }

    private static URI parseProbableURI(String scriptIdentifier) {
        URI uri = URI.create(scriptIdentifier);
        return "file".equals(uri.getScheme()) ? ScriptPath.parseAssumeFileScheme(uri.getSchemeSpecificPart()) : uri;
    }

    private static boolean isWindowsOS() {
        String osName = System.getProperty("os.name");
        return ScriptPath.normalize(osName).contains("windows");
    }

    private static boolean pathContainsWindowsDrivePattern(String scriptIdentifier) {
        return scriptIdentifier.matches("^[a-zA-Z]:.*$");
    }

    private static boolean probablyURI(String scriptIdentifier) {
        return scriptIdentifier.matches("^[a-zA-Z+.\\-]+:.*$");
    }

    private static String replaceNonStandardPathSeparator(String scriptIdentifier) {
        return scriptIdentifier.replace(File.separatorChar, '/');
    }

    private static boolean nonStandardPathSeparatorInUse(String scriptIdentifier) {
        return File.separatorChar != '/' && scriptIdentifier.contains(File.separator);
    }

    private static URI parseAssumeFileScheme(String scriptIdentifier) {
        File scriptFile = new File(scriptIdentifier);
        return scriptFile.toURI();
    }

    private static String normalize(String value) {
        return value == null ? "" : value.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }
}

