/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.guice;

import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Stage;
import io.cucumber.guice.CucumberModules;
import io.cucumber.guice.InjectorSource;
import io.cucumber.guice.InjectorSourceInstantiationFailed;
import java.text.MessageFormat;
import java.util.Map;

final class InjectorSourceFactory {
    static final String GUICE_INJECTOR_SOURCE_KEY = "guice.injector-source";
    private final Map<String, String> properties;

    InjectorSourceFactory(Map<String, String> properties) {
        this.properties = properties;
    }

    InjectorSource create() {
        String injectorSourceClassName = this.properties.get(GUICE_INJECTOR_SOURCE_KEY);
        if (injectorSourceClassName == null) {
            return this.createDefaultScenarioModuleInjectorSource();
        }
        return this.instantiateUserSpecifiedInjectorSource(injectorSourceClassName);
    }

    private InjectorSource createDefaultScenarioModuleInjectorSource() {
        return () -> Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{CucumberModules.createScenarioModule()});
    }

    private InjectorSource instantiateUserSpecifiedInjectorSource(String injectorSourceClassName) {
        try {
            return (InjectorSource)Class.forName(injectorSourceClassName, true, Thread.currentThread().getContextClassLoader()).newInstance();
        }
        catch (Exception e) {
            String message = MessageFormat.format("Instantiation of ''{0}'' failed. Check the caused by exception and ensure yourInjectorSource implementation is accessible and has a public zero args constructor.", injectorSourceClassName);
            throw new InjectorSourceInstantiationFailed(message, e);
        }
    }
}

