/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.guice;

import com.google.inject.Injector;
import io.cucumber.core.backend.CucumberBackendException;
import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.core.options.CucumberProperties;
import io.cucumber.core.resource.ClasspathSupport;
import io.cucumber.guice.InjectorSource;
import io.cucumber.guice.InjectorSourceFactory;
import io.cucumber.guice.ScenarioScope;
import java.util.Collection;
import java.util.HashSet;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class GuiceFactory
implements ObjectFactory {
    private Injector injector;
    private final Collection<Class<?>> stepClasses = new HashSet();
    private final Class<?> injectorSourceFromProperty = InjectorSourceFactory.loadInjectorSourceFromProperties(CucumberProperties.create());
    private Class<?> withInjectorSource = null;

    public boolean addClass(Class<?> stepClass) {
        if (this.stepClasses.contains(stepClass)) {
            return true;
        }
        if (this.injectorSourceFromProperty == null && this.hasInjectorSource(stepClass)) {
            this.checkOnlyOneClassHasInjectorSource(stepClass);
            this.withInjectorSource = stepClass;
        }
        this.stepClasses.add(stepClass);
        return true;
    }

    private boolean hasInjectorSource(Class<?> stepClass) {
        return InjectorSource.class.isAssignableFrom(stepClass);
    }

    private void checkOnlyOneClassHasInjectorSource(Class<?> stepClass) {
        if (this.withInjectorSource != null) {
            throw new CucumberBackendException(String.format("Glue class %1$s and %2$s are both implementing io.cucumber.guice.InjectorSource.\nPlease ensure only one class configures the Guice context\n\nBy default Cucumber scans the entire classpath for context configuration.\nYou can restrict this by configuring the glue path.\n" + ClasspathSupport.configurationExamples(), stepClass, this.withInjectorSource));
        }
    }

    void setInjector(Injector injector) {
        this.injector = injector;
    }

    public void start() {
        if (this.injector == null) {
            this.injector = new InjectorSourceFactory(this.withInjectorSource).create().getInjector();
        }
        ((ScenarioScope)this.injector.getInstance(ScenarioScope.class)).enterScope();
    }

    public void stop() {
        ((ScenarioScope)this.injector.getInstance(ScenarioScope.class)).exitScope();
    }

    public <T> T getInstance(Class<T> clazz) {
        return (T)this.injector.getInstance(clazz);
    }
}

