/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.guice;

import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Stage;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.guice.CucumberModules;
import io.cucumber.guice.GuiceFactory;
import io.cucumber.guice.InjectorSource;
import io.cucumber.guice.InjectorSourceInstantiationFailed;
import java.util.Map;

final class InjectorSourceFactory {
    private static final Logger log = LoggerFactory.getLogger(GuiceFactory.class);
    static final String GUICE_INJECTOR_SOURCE_KEY = "guice.injector-source";
    private final Class<?> injectorSourceClass;

    InjectorSourceFactory(Class<?> injectorSourceClass) {
        this.injectorSourceClass = injectorSourceClass;
    }

    InjectorSource create() {
        if (this.injectorSourceClass == null) {
            return this.createDefaultScenarioModuleInjectorSource();
        }
        return this.instantiateUserSpecifiedInjectorSource(this.injectorSourceClass);
    }

    private InjectorSource createDefaultScenarioModuleInjectorSource() {
        return () -> Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{CucumberModules.createScenarioModule()});
    }

    private InjectorSource instantiateUserSpecifiedInjectorSource(Class<?> injectorSourceClass) {
        try {
            return (InjectorSource)injectorSourceClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            String message = String.format("Instantiation of '%s' failed. Check the caused by exception and ensure yourInjectorSource implementation is accessible and has a public zero args constructor.", injectorSourceClass.getName());
            throw new InjectorSourceInstantiationFailed(message, e);
        }
    }

    @Deprecated
    static Class<?> loadInjectorSourceFromProperties(Map<String, String> properties) {
        String injectorSourceClassName = properties.get(GUICE_INJECTOR_SOURCE_KEY);
        if (injectorSourceClassName == null) {
            return null;
        }
        log.warn(() -> String.format("The '%s' property has been deprecated.Add a class implementing '%s' on the glue path instead", GUICE_INJECTOR_SOURCE_KEY, InjectorSource.class.getName()));
        try {
            return Class.forName(injectorSourceClassName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            String message = String.format("Instantiation of '%s' failed. Check the caused by exception and ensure yourInjectorSource implementation is accessible and has a public zero args constructor.", injectorSourceClassName);
            throw new InjectorSourceInstantiationFailed(message, e);
        }
    }
}

