/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.api.java.ObjectFactory;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.CucumberException;
import cucumber.runtime.NoInstancesException;
import cucumber.runtime.Reflections;
import cucumber.runtime.TooManyInstancesException;
import cucumber.runtime.java.DefaultJavaObjectFactory;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;

public final class ObjectFactoryLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectFactoryLoader.class);

    private ObjectFactoryLoader() {
    }

    public static ObjectFactory loadObjectFactory(ClassFinder classFinder, String objectFactoryClassName) {
        try {
            Reflections reflections = new Reflections(classFinder);
            if (objectFactoryClassName == null) {
                return ObjectFactoryLoader.loadSingleObjectFactory(reflections);
            }
            return ObjectFactoryLoader.loadSelectedObjectFactory(reflections, classFinder, objectFactoryClassName);
        }
        catch (TooManyInstancesException e) {
            LOG.warn(e.getMessage());
            LOG.warn(ObjectFactoryLoader.getMultipleObjectFactoryLogMessage());
            return new DefaultJavaObjectFactory();
        }
        catch (NoInstancesException e) {
            return new DefaultJavaObjectFactory();
        }
        catch (ClassNotFoundException e) {
            throw new CucumberException("Couldn't instantiate custom ObjectFactory", (Throwable)e);
        }
    }

    private static ObjectFactory loadSingleObjectFactory(Reflections reflections) {
        Iterator<io.cucumber.core.backend.ObjectFactory> serviceLoaderObjectFactories = ServiceLoader.load(io.cucumber.core.backend.ObjectFactory.class).iterator();
        if (serviceLoaderObjectFactories.hasNext()) {
            HashSet<io.cucumber.core.backend.ObjectFactory> instances = new HashSet<io.cucumber.core.backend.ObjectFactory>();
            do {
                instances.add(serviceLoaderObjectFactories.next());
            } while (serviceLoaderObjectFactories.hasNext());
            if (instances.size() > 1) {
                throw new TooManyInstancesException(instances);
            }
            return new ObjectFactoryAdapter((io.cucumber.core.backend.ObjectFactory)instances.iterator().next());
        }
        LOG.warn("Use deprecated reflections to load ObjectFactory.");
        List<URI> packages = Arrays.asList(URI.create("classpath:cucumber/runtime"));
        return (ObjectFactory)reflections.instantiateExactlyOneSubclass(ObjectFactory.class, packages, new Class[0], new Object[0], null);
    }

    private static ObjectFactory loadSelectedObjectFactory(Reflections reflections, ClassFinder classFinder, String objectFactoryClassName) throws ClassNotFoundException {
        Iterator serviceLoaderObjectFactories = ServiceLoader.load(classFinder.loadClass(objectFactoryClassName)).iterator();
        if (serviceLoaderObjectFactories.hasNext()) {
            return new ObjectFactoryAdapter((io.cucumber.core.backend.ObjectFactory)serviceLoaderObjectFactories.next());
        }
        LOG.warn("Use deprecated reflections to load requested ObjectFactory.");
        return (ObjectFactory)reflections.newInstance(new Class[0], new Object[0], classFinder.loadClass(objectFactoryClassName));
    }

    private static String getMultipleObjectFactoryLogMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("More than one Cucumber ObjectFactory was found in the classpath\n\n");
        sb.append("You probably may have included, for instance, cucumber-spring AND cucumber-guice as part of\n");
        sb.append("your dependencies. When this happens, Cucumber falls back to instantiating the\n");
        sb.append("DefaultJavaObjectFactory implementation which doesn't provide IoC.\n");
        sb.append("In order to enjoy IoC features, please remove the unnecessary dependencies from your classpath.\n");
        return sb.toString();
    }

    private static class ObjectFactoryAdapter
    implements ObjectFactory {
        private final io.cucumber.core.backend.ObjectFactory delegate;

        public ObjectFactoryAdapter(io.cucumber.core.backend.ObjectFactory delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        @Override
        public void start() {
            this.delegate.start();
        }

        @Override
        public void stop() {
            this.delegate.stop();
        }

        @Override
        public boolean addClass(Class<?> arg0) {
            return this.delegate.addClass(arg0);
        }

        @Override
        public <T> T getInstance(Class<T> arg0) {
            return (T)this.delegate.getInstance(arg0);
        }
    }
}

