/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java;

import io.cucumber.core.backend.Backend;
import io.cucumber.core.backend.Container;
import io.cucumber.core.backend.Glue;
import io.cucumber.core.backend.Lookup;
import io.cucumber.core.backend.Snippet;
import io.cucumber.core.io.ClassFinder;
import io.cucumber.core.io.MultiLoader;
import io.cucumber.core.io.ResourceLoader;
import io.cucumber.core.io.ResourceLoaderClassFinder;
import io.cucumber.java.GlueAdaptor;
import io.cucumber.java.JavaSnippet;
import io.cucumber.java.MethodScanner;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import java.util.function.Supplier;

final class JavaBackend
implements Backend {
    private final Lookup lookup;
    private final Container container;
    private final ClassFinder classFinder;

    JavaBackend(Lookup lookup, Container container, Supplier<ClassLoader> classLoaderSupplier) {
        this.lookup = lookup;
        this.container = container;
        ClassLoader classLoader = classLoaderSupplier.get();
        MultiLoader resourceLoader = new MultiLoader(classLoader);
        this.classFinder = new ResourceLoaderClassFinder((ResourceLoader)resourceLoader, classLoader);
    }

    public void loadGlue(Glue glue, List<URI> gluePaths) {
        GlueAdaptor glueAdaptor = new GlueAdaptor(this.lookup, glue);
        for (URI gluePath : gluePaths) {
            for (Class glueCodeClass : this.classFinder.getDescendants(Object.class, gluePath)) {
                MethodScanner.scan(glueCodeClass, (method, annotation) -> {
                    this.container.addClass(method.getDeclaringClass());
                    glueAdaptor.addDefinition((Method)method, (Annotation)annotation);
                });
            }
        }
    }

    public void buildWorld() {
    }

    public void disposeWorld() {
    }

    public Snippet getSnippet() {
        return new JavaSnippet();
    }
}

