/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java;

import io.cucumber.core.backend.Located;
import io.cucumber.core.backend.Lookup;
import io.cucumber.java.Invoker;
import io.cucumber.java.MethodFormat;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;

abstract class AbstractGlueDefinition
implements Located {
    protected final Method method;
    private final Lookup lookup;
    private String fullFormat;

    AbstractGlueDefinition(Method method, Lookup lookup) {
        this.method = Objects.requireNonNull(method);
        this.lookup = Objects.requireNonNull(lookup);
    }

    public boolean isDefinedAt(StackTraceElement e) {
        return e.getClassName().equals(this.method.getDeclaringClass().getName()) && e.getMethodName().equals(this.method.getName());
    }

    public final String getLocation() {
        return this.getFullLocationLocation();
    }

    private String getFullLocationLocation() {
        if (this.fullFormat == null) {
            this.fullFormat = MethodFormat.FULL.format(this.method);
        }
        return this.fullFormat;
    }

    final Object invokeMethod(Object ... args) {
        if (Modifier.isStatic(this.method.getModifiers())) {
            return Invoker.invokeStatic(this, this.method, args);
        }
        return Invoker.invoke(this, this.lookup.getInstance(this.method.getDeclaringClass()), this.method, args);
    }
}

