package cucumber.api.java8;

import cucumber.api.java8.StepdefBody.A0;
import cucumber.api.java8.StepdefBody.A1;
import cucumber.api.java8.StepdefBody.A2;
import cucumber.api.java8.StepdefBody.A3;
import cucumber.api.java8.StepdefBody.A4;
import cucumber.api.java8.StepdefBody.A5;
import cucumber.api.java8.StepdefBody.A6;
import cucumber.api.java8.StepdefBody.A7;
import cucumber.api.java8.StepdefBody.A8;
import cucumber.api.java8.StepdefBody.A9;

import cucumber.runtime.java.LambdaGlueRegistry;
import cucumber.runtime.java8.Java8StepDefinition;
import cucumber.runtime.java8.LambdaGlueBase;

/**
 * To execute steps in a feature file the steps must be
 * connected to executable code. This can be done by
 * implementing this interface.
 * <p>
 * The parameters extracted from the step by the expression
 * along with the data table or doc string argument are provided as
 * arguments to the lambda expression.
 * <p>
 * The types of the parameters are determined by the cucumber or
 * regular expression.
 * <p>
 * The type of the data table or doc string argument is determined
 * by the argument name value. When none is provided cucumber will
 * attempt to transform the data table or doc string to the the
 * type of last argument.
 */
public interface Cs extends LambdaGlueBase {

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void A(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void A(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void A(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void A(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void A(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void A(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void A(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void A(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void A(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void A(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void A(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void A(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void A(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void A(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void A(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void A(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void A(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void A(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void A(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void A(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Ataké(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Ataké(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void Ataké(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void Ataké(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void Ataké(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void Ataké(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void Ataké(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void Ataké(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void Ataké(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void Ataké(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void Ataké(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void Ataké(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void Ataké(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void Ataké(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void Ataké(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Ataké(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Ataké(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Ataké(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Ataké(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Ataké(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Ale(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Ale(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void Ale(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void Ale(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void Ale(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void Ale(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void Ale(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void Ale(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void Ale(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void Ale(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void Ale(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void Ale(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void Ale(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void Ale(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void Ale(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Ale(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Ale(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Ale(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Ale(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Ale(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Když(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Když(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void Když(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void Když(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void Když(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void Když(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void Když(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void Když(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void Když(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void Když(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void Když(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void Když(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void Když(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void Když(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void Když(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Když(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Když(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Když(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Když(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Když(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Pak(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Pak(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void Pak(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void Pak(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void Pak(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void Pak(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void Pak(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void Pak(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void Pak(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void Pak(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void Pak(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void Pak(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void Pak(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void Pak(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void Pak(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Pak(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Pak(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Pak(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Pak(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Pak(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Pokud(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Pokud(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void Pokud(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void Pokud(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void Pokud(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void Pokud(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void Pokud(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void Pokud(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void Pokud(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void Pokud(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void Pokud(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void Pokud(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void Pokud(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void Pokud(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void Pokud(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Pokud(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Pokud(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Pokud(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Pokud(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Pokud(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Zapředpokladu(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Zapředpokladu(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void Zapředpokladu(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void Zapředpokladu(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void Zapředpokladu(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void Zapředpokladu(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void Zapředpokladu(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void Zapředpokladu(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void Zapředpokladu(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void Zapředpokladu(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void Zapředpokladu(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void Zapředpokladu(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void Zapředpokladu(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void Zapředpokladu(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void Zapředpokladu(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Zapředpokladu(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Zapředpokladu(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Zapředpokladu(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Zapředpokladu(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Zapředpokladu(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

}
