package io.cucumber.java8;

import io.cucumber.java8.StepDefinitionBody.A0;
import io.cucumber.java8.StepDefinitionBody.A1;
import io.cucumber.java8.StepDefinitionBody.A2;
import io.cucumber.java8.StepDefinitionBody.A3;
import io.cucumber.java8.StepDefinitionBody.A4;
import io.cucumber.java8.StepDefinitionBody.A5;
import io.cucumber.java8.StepDefinitionBody.A6;
import io.cucumber.java8.StepDefinitionBody.A7;
import io.cucumber.java8.StepDefinitionBody.A8;
import io.cucumber.java8.StepDefinitionBody.A9;

import io.cucumber.java8.LambdaGlueRegistry;
import io.cucumber.java8.Java8StepDefinition;
import io.cucumber.java8.LambdaGlue;

import org.apiguardian.api.API;

/**
 * Mongolian - монгол
 * <p>
 * To execute steps in a feature file the steps must be
 * connected to executable code. This can be done by
 * implementing this interface.
 * <p>
 * The parameters extracted from the step by the expression
 * along with the data table or doc string argument are provided as
 * arguments to the lambda expression.
 * <p>
 * The types of the parameters are determined by the cucumber or
 * regular expression.
 * <p>
 * The type of the data table or doc string argument is determined
 * by the argument name value. When none is provided cucumber will
 * attempt to transform the data table or doc string to the
 * type of last argument.
 */
@API(status = API.Status.STABLE)
public interface Mn extends LambdaGlue {

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Анх(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Анх(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Анх(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Анх(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Анх(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Анх(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Анх(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Анх(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Анх(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Анх(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Гэхдээ(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Гэхдээ(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Гэхдээ(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Гэхдээ(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Гэхдээ(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Гэхдээ(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Гэхдээ(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Гэхдээ(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Гэхдээ(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Гэхдээ(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Мөн(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Мөн(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Мөн(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Мөн(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Мөн(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Мөн(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Мөн(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Мөн(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Мөн(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Мөн(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Тэгэхэд(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Тэгэхэд(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Тэгэхэд(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Тэгэхэд(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Тэгэхэд(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Тэгэхэд(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Тэгэхэд(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Тэгэхэд(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Тэгэхэд(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Тэгэхэд(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Тэгээд(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Тэгээд(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Тэгээд(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Тэгээд(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Тэгээд(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Тэгээд(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Тэгээд(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Тэгээд(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Тэгээд(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Тэгээд(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Харин(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Харин(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Харин(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Харин(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Харин(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Харин(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Харин(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Харин(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Харин(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Харин(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Хэрэв(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Хэрэв(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Хэрэв(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Хэрэв(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Хэрэв(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Хэрэв(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Хэрэв(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Хэрэв(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Хэрэв(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Хэрэв(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Үүнийдараа(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Үүнийдараа(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Үүнийдараа(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Үүнийдараа(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Үүнийдараа(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Үүнийдараа(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Үүнийдараа(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Үүнийдараа(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Үүнийдараа(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Үүнийдараа(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Өгөгдсөннь(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Өгөгдсөннь(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Өгөгдсөннь(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Өгөгдсөннь(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Өгөгдсөннь(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Өгөгдсөннь(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Өгөгдсөннь(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Өгөгдсөннь(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Өгөгдсөннь(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Өгөгдсөннь(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }

}
