package io.cucumber.java8;

import io.cucumber.java8.StepDefinitionBody.A0;
import io.cucumber.java8.StepDefinitionBody.A1;
import io.cucumber.java8.StepDefinitionBody.A2;
import io.cucumber.java8.StepDefinitionBody.A3;
import io.cucumber.java8.StepDefinitionBody.A4;
import io.cucumber.java8.StepDefinitionBody.A5;
import io.cucumber.java8.StepDefinitionBody.A6;
import io.cucumber.java8.StepDefinitionBody.A7;
import io.cucumber.java8.StepDefinitionBody.A8;
import io.cucumber.java8.StepDefinitionBody.A9;

import io.cucumber.java8.LambdaGlueRegistry;
import io.cucumber.java8.Java8StepDefinition;
import io.cucumber.java8.LambdaGlue;

import org.apiguardian.api.API;

/**
 * Russian - русский
 * <p>
 * To execute steps in a feature file the steps must be
 * connected to executable code. This can be done by
 * implementing this interface.
 * <p>
 * The parameters extracted from the step by the expression
 * along with the data table or doc string argument are provided as
 * arguments to the lambda expression.
 * <p>
 * The types of the parameters are determined by the cucumber or
 * regular expression.
 * <p>
 * The type of the data table or doc string argument is determined
 * by the argument name value. When none is provided cucumber will
 * attempt to transform the data table or doc string to the
 * type of last argument.
 */
@API(status = API.Status.STABLE)
public interface Ru extends LambdaGlue {

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void А(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void А(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void А(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void А(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void А(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void А(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void А(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void А(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void А(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void А(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Дано(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Дано(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Дано(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Дано(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Дано(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Дано(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Дано(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Дано(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Дано(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Дано(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Допустим(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Допустим(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Допустим(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Допустим(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Допустим(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Допустим(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Допустим(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Допустим(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Допустим(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Допустим(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Если(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Если(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Если(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Если(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Если(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Если(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Если(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Если(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Если(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Если(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Затем(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Затем(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Затем(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Затем(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Затем(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Затем(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Затем(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Затем(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Затем(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Затем(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void И(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void И(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void И(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void И(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void И(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void И(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void И(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void И(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void И(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void И(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Иначе(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Иначе(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Иначе(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Иначе(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Иначе(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Иначе(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Иначе(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Иначе(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Иначе(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Иначе(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Ктомуже(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Ктомуже(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Ктомуже(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Ктомуже(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Ктомуже(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Ктомуже(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Ктомуже(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Ктомуже(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Ктомуже(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Ктомуже(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Когда(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Когда(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Когда(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Когда(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Когда(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Когда(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Когда(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Когда(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Когда(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Когда(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Но(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Но(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Но(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Но(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Но(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Но(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Но(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Но(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Но(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Но(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Пусть(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Пусть(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Пусть(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Пусть(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Пусть(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Пусть(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Пусть(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Пусть(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Пусть(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Пусть(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Также(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Также(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Также(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Также(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Также(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Также(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Также(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Также(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Также(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Также(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void То(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void То(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void То(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void То(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void То(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void То(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void То(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void То(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void То(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void То(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Тогда(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Тогда(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Тогда(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Тогда(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Тогда(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Тогда(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Тогда(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Тогда(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Тогда(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Тогда(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }

}
