/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.feature.CucumberExample;
import io.cucumber.core.feature.CucumberExamples;
import io.cucumber.core.feature.CucumberFeature;
import io.cucumber.core.feature.CucumberPickle;
import io.cucumber.core.feature.CucumberScenario;
import io.cucumber.core.feature.CucumberScenarioDefinition;
import io.cucumber.core.feature.CucumberScenarioOutline;
import io.cucumber.core.feature.Located;
import io.cucumber.core.feature.Named;
import io.cucumber.junit.platform.engine.CucumberEngineExecutionContext;
import io.cucumber.junit.platform.engine.FeatureOrigin;
import io.cucumber.junit.platform.engine.NodeDescriptor;
import io.cucumber.junit.platform.engine.PickleDescriptor;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.hierarchical.Node;

class FeatureDescriptor
extends AbstractTestDescriptor
implements Node<CucumberEngineExecutionContext> {
    private final CucumberFeature feature;

    private FeatureDescriptor(UniqueId uniqueId, String name, TestSource source, CucumberFeature feature) {
        super(uniqueId, name, source);
        this.feature = feature;
    }

    static TestDescriptor create(CucumberFeature cucumberFeature, TestDescriptor parent) {
        FeatureOrigin source = FeatureOrigin.fromUri(cucumberFeature.getUri());
        FeatureDescriptor descriptor = new FeatureDescriptor(source.featureSegment(parent.getUniqueId(), cucumberFeature), FeatureDescriptor.getNameOrKeyWord(cucumberFeature), source.featureSource(), cucumberFeature);
        parent.addChild((TestDescriptor)descriptor);
        cucumberFeature.children().forEach(arg_0 -> FeatureDescriptor.lambda$create$0(cucumberFeature, (TestDescriptor)descriptor, source, arg_0));
        return descriptor;
    }

    private static <T extends Located & Named> void visit(CucumberFeature feature, TestDescriptor parent, FeatureOrigin source, T node) {
        NodeDescriptor descriptor;
        if (node instanceof CucumberScenario) {
            feature.getPickleAt(node.getLocation()).ifPresent(pickle -> {
                PickleDescriptor descriptor = new PickleDescriptor(source.scenarioSegment(parent.getUniqueId(), node), FeatureDescriptor.getNameOrKeyWord(node), source.nodeSource(node), (CucumberPickle)pickle);
                parent.addChild((TestDescriptor)descriptor);
            });
        }
        if (node instanceof CucumberScenarioOutline) {
            descriptor = new NodeDescriptor(source.scenarioSegment(parent.getUniqueId(), node), FeatureDescriptor.getNameOrKeyWord(node), source.nodeSource(node));
            parent.addChild((TestDescriptor)descriptor);
            CucumberScenarioOutline scenarioOutline = (CucumberScenarioOutline)node;
            scenarioOutline.children().forEach(section -> FeatureDescriptor.visit(feature, (TestDescriptor)descriptor, source, section));
        }
        if (node instanceof CucumberExamples) {
            descriptor = new NodeDescriptor(source.examplesSegment(parent.getUniqueId(), node), FeatureDescriptor.getNameOrKeyWord(node), source.nodeSource(node));
            parent.addChild((TestDescriptor)descriptor);
            CucumberExamples examples = (CucumberExamples)node;
            examples.children().forEach(example -> FeatureDescriptor.visit(feature, (TestDescriptor)descriptor, source, example));
        }
        if (node instanceof CucumberExample) {
            feature.getPickleAt(node.getLocation()).ifPresent(pickle -> {
                PickleDescriptor descriptor = new PickleDescriptor(source.exampleSegment(parent.getUniqueId(), node), FeatureDescriptor.getNameOrKeyWord(node), source.nodeSource(node), (CucumberPickle)pickle);
                parent.addChild((TestDescriptor)descriptor);
            });
        }
    }

    private static <T extends Located & Named> String getNameOrKeyWord(T node) {
        String name = ((Named)node).getName();
        return name.isEmpty() ? ((Named)node).getKeyWord() : name;
    }

    public CucumberEngineExecutionContext prepare(CucumberEngineExecutionContext context) {
        context.beforeFeature(this.feature);
        return context;
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    private static /* synthetic */ void lambda$create$0(CucumberFeature cucumberFeature, TestDescriptor descriptor, FeatureOrigin source, CucumberScenarioDefinition scenarioDefinition) {
        FeatureDescriptor.visit(cucumberFeature, descriptor, source, scenarioDefinition);
    }
}

