/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.feature.CucumberFeature;
import io.cucumber.core.feature.CucumberLocation;
import io.cucumber.core.feature.Located;
import java.io.File;
import java.net.URI;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClasspathResourceSource;
import org.junit.platform.engine.support.descriptor.FilePosition;
import org.junit.platform.engine.support.descriptor.FileSource;
import org.junit.platform.engine.support.descriptor.UriSource;

abstract class FeatureOrigin {
    private static final String FEATURE_SEGMENT_TYPE = "feature";
    private static final String SCENARIO_SEGMENT_TYPE = "scenario";
    private static final String EXAMPLES_SEGMENT_TYPE = "examples";
    private static final String EXAMPLE_SEGMENT_TYPE = "example";

    FeatureOrigin() {
    }

    private static FilePosition createFilePosition(CucumberLocation location) {
        return FilePosition.from((int)location.getLine(), (int)location.getColumn());
    }

    static FeatureOrigin fromUri(URI uri) {
        if ("classpath".equals(uri.getScheme())) {
            if (!uri.getSchemeSpecificPart().startsWith("/")) {
                uri = URI.create("classpath:/" + uri.getSchemeSpecificPart());
            }
            ClasspathResourceSource source = ClasspathResourceSource.from((URI)uri);
            return new ClasspathFeatureOrigin(source);
        }
        UriSource source = UriSource.from((URI)uri);
        if (source instanceof FileSource) {
            return new FileFeatureOrigin((FileSource)source);
        }
        return new UriFeatureOrigin(source);
    }

    static boolean isFeatureSegment(UniqueId.Segment segment) {
        return FEATURE_SEGMENT_TYPE.equals(segment.getType());
    }

    abstract TestSource featureSource();

    abstract TestSource nodeSource(Located var1);

    abstract UniqueId featureSegment(UniqueId var1, CucumberFeature var2);

    UniqueId scenarioSegment(UniqueId parent, Located scenarioDefinition) {
        return parent.append(SCENARIO_SEGMENT_TYPE, String.valueOf(scenarioDefinition.getLocation().getLine()));
    }

    UniqueId examplesSegment(UniqueId parent, Located examples) {
        return parent.append(EXAMPLES_SEGMENT_TYPE, String.valueOf(examples.getLocation().getLine()));
    }

    UniqueId exampleSegment(UniqueId parent, Located tableRow) {
        return parent.append(EXAMPLE_SEGMENT_TYPE, String.valueOf(tableRow.getLocation().getLine()));
    }

    private static class ClasspathFeatureOrigin
    extends FeatureOrigin {
        private final ClasspathResourceSource source;

        ClasspathFeatureOrigin(ClasspathResourceSource source) {
            this.source = source;
        }

        @Override
        TestSource featureSource() {
            return this.source;
        }

        @Override
        TestSource nodeSource(Located node) {
            return ClasspathResourceSource.from((String)this.source.getClasspathResourceName(), (FilePosition)FeatureOrigin.createFilePosition(node.getLocation()));
        }

        @Override
        UniqueId featureSegment(UniqueId parent, CucumberFeature feature) {
            return parent.append(FeatureOrigin.FEATURE_SEGMENT_TYPE, feature.getUri().toString());
        }
    }

    private static class UriFeatureOrigin
    extends FeatureOrigin {
        private final UriSource source;

        UriFeatureOrigin(UriSource source) {
            this.source = source;
        }

        @Override
        TestSource featureSource() {
            return this.source;
        }

        @Override
        TestSource nodeSource(Located node) {
            return this.source;
        }

        @Override
        UniqueId featureSegment(UniqueId parent, CucumberFeature feature) {
            return parent.append(FeatureOrigin.FEATURE_SEGMENT_TYPE, this.source.getUri().toString());
        }
    }

    private static class FileFeatureOrigin
    extends FeatureOrigin {
        private final FileSource source;

        FileFeatureOrigin(FileSource source) {
            this.source = source;
        }

        @Override
        TestSource featureSource() {
            return this.source;
        }

        @Override
        TestSource nodeSource(Located node) {
            return FileSource.from((File)this.source.getFile(), (FilePosition)FeatureOrigin.createFilePosition(node.getLocation()));
        }

        @Override
        UniqueId featureSegment(UniqueId parent, CucumberFeature feature) {
            return parent.append(FeatureOrigin.FEATURE_SEGMENT_TYPE, this.source.getUri().toString());
        }
    }
}

