/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.feature.CucumberFeature;
import io.cucumber.core.feature.FeatureIdentifier;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.resource.ClassLoaders;
import io.cucumber.core.resource.Resource;
import io.cucumber.core.resource.ResourceScanner;
import io.cucumber.junit.platform.engine.Cucumber;
import io.cucumber.junit.platform.engine.FeatureDescriptor;
import io.cucumber.junit.platform.engine.FeatureOrigin;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.BlacklistedExceptions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathResourceSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.DirectorySelector;
import org.junit.platform.engine.discovery.FileSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.discovery.UriSelector;

final class FeatureResolver {
    private static final Logger logger = LoggerFactory.getLogger(FeatureResolver.class);
    private final ResourceScanner<CucumberFeature> featureScanner = new ResourceScanner(ClassLoaders::getDefaultClassLoader, FeatureIdentifier::isFeature, resource -> Optional.of(FeatureParser.parseResource((Resource)resource)));
    private final TestDescriptor engineDescriptor;
    private final Predicate<String> packageFilter;

    private FeatureResolver(TestDescriptor engineDescriptor, Predicate<String> packageFilter) {
        this.engineDescriptor = engineDescriptor;
        this.packageFilter = packageFilter;
    }

    static FeatureResolver createFeatureResolver(TestDescriptor engineDescriptor, Predicate<String> packageFilter) {
        return new FeatureResolver(engineDescriptor, packageFilter);
    }

    private static void recursivelyMerge(TestDescriptor descriptor, TestDescriptor parent) {
        Optional byUniqueId = parent.findByUniqueId(descriptor.getUniqueId());
        if (!byUniqueId.isPresent()) {
            parent.addChild(descriptor);
            return;
        }
        byUniqueId.ifPresent(existingParent -> descriptor.getChildren().forEach(child -> FeatureResolver.recursivelyMerge(child, existingParent)));
    }

    void resolveClass(ClassSelector classSelector) {
        Class javaClass = classSelector.getJavaClass();
        Cucumber annotation = javaClass.getAnnotation(Cucumber.class);
        if (annotation != null) {
            this.resolvePackageResource(javaClass.getPackage().getName());
        }
    }

    void resolveDirectory(DirectorySelector selector) {
        this.resolvePath(selector.getPath());
    }

    private void resolvePath(Path path) {
        this.featureScanner.scanForResourcesPath(path).stream().map(this::resolveFeature).forEach(this::merge);
    }

    private void merge(TestDescriptor featureDescriptor) {
        FeatureResolver.recursivelyMerge(featureDescriptor, this.engineDescriptor);
    }

    void resolveFile(FileSelector selector) {
        this.resolvePath(selector.getPath());
    }

    void resolvePackageResource(PackageSelector selector) {
        this.resolvePackageResource(selector.getPackageName());
    }

    private void resolvePackageResource(String packageName) {
        this.featureScanner.scanForResourcesInPackage(packageName, this.packageFilter).stream().map(this::resolveFeature).forEach(this::merge);
    }

    void resolveClasspathResource(ClasspathResourceSelector selector) {
        String classpathResourceName = selector.getClasspathResourceName();
        this.featureScanner.scanForClasspathResource(classpathResourceName, this.packageFilter).stream().map(this::resolveFeature).forEach(this::merge);
    }

    void resolveClasspathRoot(ClasspathRootSelector selector) {
        this.featureScanner.scanForResourcesInClasspathRoot(selector.getClasspathRoot(), this.packageFilter).stream().map(this::resolveFeature).forEach(this::merge);
    }

    void resolveUri(UriSelector selector) {
        URI uri = selector.getUri();
        try {
            this.resolveUri(uri).forEach(this::merge);
        }
        catch (Throwable e) {
            BlacklistedExceptions.rethrowIfBlacklisted((Throwable)e);
            logger.debug(e, () -> String.format("Failed to resolve features for uri '%s'.", uri));
        }
    }

    private Stream<TestDescriptor> resolveUri(URI uri) {
        return this.featureScanner.scanForResourcesUri(uri).stream().map(this::resolveFeature);
    }

    void resolveUniqueId(UniqueIdSelector uniqueIdSelector) {
        UniqueId uniqueId = uniqueIdSelector.getUniqueId();
        if (!this.engineDescriptor.getUniqueId().getEngineId().equals(uniqueId.getEngineId())) {
            return;
        }
        uniqueId.getSegments().stream().filter(FeatureOrigin::isFeatureSegment).map(UniqueId.Segment::getValue).map(URI::create).flatMap(this::resolveUri).map(descriptor -> this.pruneDescription((TestDescriptor)descriptor, uniqueIdSelector.getUniqueId())).forEach(this::merge);
    }

    private TestDescriptor pruneDescription(TestDescriptor descriptor, UniqueId toKeep) {
        this.pruneDescriptionRecursively(descriptor, toKeep);
        return descriptor;
    }

    private void pruneDescriptionRecursively(TestDescriptor descriptor, UniqueId toKeep) {
        if (descriptor.isTest() && !descriptor.getUniqueId().hasPrefix(toKeep)) {
            descriptor.removeFromHierarchy();
            return;
        }
        ArrayList children = new ArrayList(descriptor.getChildren());
        children.forEach(child -> this.pruneDescriptionRecursively((TestDescriptor)child, toKeep));
    }

    private TestDescriptor resolveFeature(CucumberFeature feature) {
        return FeatureDescriptor.create(feature, this.engineDescriptor);
    }
}

