/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.feature.FeatureIdentifier;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.resource.ClassLoaders;
import io.cucumber.core.resource.ResourceScanner;
import io.cucumber.junit.platform.engine.Cucumber;
import io.cucumber.junit.platform.engine.FeatureDescriptor;
import io.cucumber.junit.platform.engine.FeatureOrigin;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathResourceSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.DirectorySelector;
import org.junit.platform.engine.discovery.FileSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.discovery.UriSelector;
import org.junit.platform.engine.support.descriptor.ClasspathResourceSource;
import org.junit.platform.engine.support.descriptor.FilePosition;
import org.junit.platform.engine.support.descriptor.FileSource;

final class FeatureResolver {
    private final FeatureParser featureParser = new FeatureParser(UUID::randomUUID);
    private final ResourceScanner<Feature> featureScanner = new ResourceScanner(ClassLoaders::getDefaultClassLoader, FeatureIdentifier::isFeature, resource -> this.featureParser.parseResource(resource));
    private final TestDescriptor engineDescriptor;
    private final Predicate<String> packageFilter;

    private FeatureResolver(TestDescriptor engineDescriptor, Predicate<String> packageFilter) {
        this.engineDescriptor = engineDescriptor;
        this.packageFilter = packageFilter;
    }

    static FeatureResolver createFeatureResolver(TestDescriptor engineDescriptor, Predicate<String> packageFilter) {
        return new FeatureResolver(engineDescriptor, packageFilter);
    }

    private static void recursivelyMerge(TestDescriptor descriptor, TestDescriptor parent) {
        Optional byUniqueId = parent.findByUniqueId(descriptor.getUniqueId());
        if (!byUniqueId.isPresent()) {
            parent.addChild(descriptor);
            return;
        }
        byUniqueId.ifPresent(existingParent -> descriptor.getChildren().forEach(child -> FeatureResolver.recursivelyMerge(child, existingParent)));
    }

    private static URI stripQuery(URI uri) {
        if (uri.getQuery() == null) {
            return uri;
        }
        String uriString = uri.toString();
        return URI.create(uriString.substring(0, uriString.indexOf(63)));
    }

    private static Predicate<TestDescriptor> testDescriptorOnLine(Integer line) {
        return descriptor -> descriptor.getSource().flatMap(testSource -> {
            if (testSource instanceof FileSource) {
                FileSource fileSystemSource = (FileSource)testSource;
                return fileSystemSource.getPosition();
            }
            if (testSource instanceof ClasspathResourceSource) {
                ClasspathResourceSource classpathResourceSource = (ClasspathResourceSource)testSource;
                return classpathResourceSource.getPosition();
            }
            return Optional.empty();
        }).map(FilePosition::getLine).map(line::equals).orElse(false);
    }

    private static Function<TestDescriptor, TestDescriptor> pruneDescriptions(Predicate<TestDescriptor> toKeep) {
        return descriptor -> {
            FeatureResolver.pruneDescriptionRecursively(descriptor, toKeep);
            return descriptor;
        };
    }

    private static void pruneDescriptionRecursively(TestDescriptor descriptor, Predicate<TestDescriptor> toKeep) {
        if (toKeep.test(descriptor)) {
            return;
        }
        if (descriptor.isTest()) {
            descriptor.removeFromHierarchy();
        }
        ArrayList children = new ArrayList(descriptor.getChildren());
        children.forEach(child -> FeatureResolver.pruneDescriptionRecursively(child, toKeep));
    }

    private void merge(TestDescriptor featureDescriptor) {
        FeatureResolver.recursivelyMerge(featureDescriptor, this.engineDescriptor);
    }

    void resolveFile(FileSelector selector) {
        this.resolvePath(selector.getPath());
    }

    void resolveDirectory(DirectorySelector selector) {
        this.resolvePath(selector.getPath());
    }

    private void resolvePath(Path path) {
        this.featureScanner.scanForResourcesPath(path).stream().map(this::resolveFeature).forEach(this::merge);
    }

    void resolvePackageResource(PackageSelector selector) {
        this.resolvePackageResource(selector.getPackageName());
    }

    void resolveClass(ClassSelector classSelector) {
        Class javaClass = classSelector.getJavaClass();
        Cucumber annotation = javaClass.getAnnotation(Cucumber.class);
        if (annotation != null) {
            this.resolvePackageResource(javaClass.getPackage().getName());
        }
    }

    private void resolvePackageResource(String packageName) {
        this.featureScanner.scanForResourcesInPackage(packageName, this.packageFilter).stream().map(this::resolveFeature).forEach(this::merge);
    }

    void resolveClasspathResource(ClasspathResourceSelector selector) {
        String classpathResourceName = selector.getClasspathResourceName();
        this.featureScanner.scanForClasspathResource(classpathResourceName, this.packageFilter).stream().map(this::resolveFeature).forEach(this::merge);
    }

    void resolveClasspathRoot(ClasspathRootSelector selector) {
        this.featureScanner.scanForResourcesInClasspathRoot(selector.getClasspathRoot(), this.packageFilter).stream().map(this::resolveFeature).forEach(this::merge);
    }

    void resolveUniqueId(UniqueIdSelector uniqueIdSelector) {
        UniqueId uniqueId = uniqueIdSelector.getUniqueId();
        if (!this.engineDescriptor.getUniqueId().getEngineId().equals(uniqueId.getEngineId())) {
            return;
        }
        Predicate<TestDescriptor> keepTestWithSelectedId = testDescriptor -> uniqueId.equals((Object)testDescriptor.getUniqueId());
        uniqueId.getSegments().stream().filter(FeatureOrigin::isFeatureSegment).map(UniqueId.Segment::getValue).map(URI::create).flatMap(this::resolveUri).map(FeatureResolver.pruneDescriptions(keepTestWithSelectedId)).forEach(this::merge);
    }

    void resolveUri(UriSelector selector) {
        URI uri = selector.getUri();
        Predicate<TestDescriptor> keepTestOnSelectedLine = FilePosition.fromQuery((String)uri.getQuery()).map(FilePosition::getLine).map(FeatureResolver::testDescriptorOnLine).orElse(testDescriptor -> true);
        this.resolveUri(FeatureResolver.stripQuery(uri)).map(FeatureResolver.pruneDescriptions(keepTestOnSelectedLine)).forEach(this::merge);
    }

    private Stream<TestDescriptor> resolveUri(URI uri) {
        return this.featureScanner.scanForResourcesUri(uri).stream().map(this::resolveFeature);
    }

    private TestDescriptor resolveFeature(Feature feature) {
        return FeatureDescriptor.create(feature, this.engineDescriptor);
    }
}

