/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.core.feature.GluePath;
import io.cucumber.core.options.ObjectFactoryParser;
import io.cucumber.core.options.PluginOption;
import io.cucumber.core.options.SnippetTypeParser;
import io.cucumber.core.plugin.Options;
import io.cucumber.core.snippets.SnippetType;
import io.cucumber.tagexpressions.Expression;
import io.cucumber.tagexpressions.TagExpressionParser;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.platform.engine.ConfigurationParameters;

class CucumberEngineOptions
implements Options,
io.cucumber.core.runner.Options,
io.cucumber.core.backend.Options {
    private final ConfigurationParameters configurationParameters;

    CucumberEngineOptions(ConfigurationParameters configurationParameters) {
        this.configurationParameters = configurationParameters;
    }

    public List<Options.Plugin> plugins() {
        return this.configurationParameters.get("cucumber.plugin", s -> Arrays.stream(s.split(",")).map(String::trim).map(PluginOption::parse).map(pluginOption -> pluginOption).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public boolean isMonochrome() {
        return this.configurationParameters.getBoolean("cucumber.ansi-colors.disabled").orElse(false);
    }

    public boolean isWip() {
        return false;
    }

    Optional<Expression> tagFilter() {
        return this.configurationParameters.get("cucumber.filter.tags", TagExpressionParser::parse);
    }

    Optional<Pattern> nameFilter() {
        return this.configurationParameters.get("cucumber.filter.name", Pattern::compile);
    }

    public List<URI> getGlue() {
        return this.configurationParameters.get("cucumber.glue", s -> Arrays.asList(s.split(","))).orElse(Collections.singletonList("classpath:")).stream().map(String::trim).map(GluePath::parse).collect(Collectors.toList());
    }

    public boolean isDryRun() {
        return this.configurationParameters.getBoolean("cucumber.execution.dry-run").orElse(false);
    }

    public SnippetType getSnippetType() {
        return this.configurationParameters.get("cucumber.snippet-type", SnippetTypeParser::parseSnippetType).orElse(SnippetType.UNDERSCORE);
    }

    public Class<? extends ObjectFactory> getObjectFactoryClass() {
        return this.configurationParameters.get("cucumber.object-factory", ObjectFactoryParser::parseObjectFactory).orElse(null);
    }

    boolean isParallelExecutionEnabled() {
        return this.configurationParameters.get("cucumber.execution.parallel.enabled", Boolean::parseBoolean).orElse(false);
    }
}

