/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.gherkin.Pickle;
import io.cucumber.junit.platform.engine.NamingStrategy;
import io.cucumber.plugin.event.Node;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.platform.engine.ConfigurationParameters;

enum DefaultNamingStrategyProvider {
    LONG{

        @Override
        NamingStrategy create(ConfigurationParameters configuration) {
            return configuration.get("cucumber.junit-platform.naming-strategy.long.example-name").map(x$0 -> DefaultNamingStrategyProvider.parseStrategy(x$0)).orElse(x$0 -> DefaultNamingStrategyProvider.exampleNumberAndPickleIfParameterizedStrategy(x$0)).apply((x$0, x$1) -> DefaultNamingStrategyProvider.longStrategy(x$0, x$1));
        }
    }
    ,
    SHORT{

        @Override
        NamingStrategy create(ConfigurationParameters configuration) {
            return configuration.get("cucumber.junit-platform.naming-strategy.short.example-name").map(x$0 -> DefaultNamingStrategyProvider.parseStrategy(x$0)).orElse(x$0 -> DefaultNamingStrategyProvider.exampleNumberAndPickleIfParameterizedStrategy(x$0)).apply((x$0, x$1) -> DefaultNamingStrategyProvider.shortStrategy(x$0, x$1));
        }
    }
    ,
    SUREFIRE{

        @Override
        NamingStrategy create(ConfigurationParameters configuration) {
            return configuration.get("cucumber.junit-platform.naming-strategy.surefire.example-name").map(x$0 -> DefaultNamingStrategyProvider.parseStrategy(x$0)).orElse(x$0 -> DefaultNamingStrategyProvider.exampleNumberAndPickleIfParameterizedStrategy(x$0)).apply((x$0, x$1) -> DefaultNamingStrategyProvider.surefireStrategy(x$0, x$1));
        }
    };


    abstract NamingStrategy create(ConfigurationParameters var1);

    static DefaultNamingStrategyProvider getStrategyProvider(String name) {
        return DefaultNamingStrategyProvider.valueOf(name.toUpperCase(Locale.ROOT));
    }

    private static Function<BiFunction<Node, String, String>, NamingStrategy> parseStrategy(String exampleStrategy) {
        switch (exampleStrategy) {
            case "number": {
                return DefaultNamingStrategyProvider::exampleNumberStrategy;
            }
            case "number-and-pickle-if-parameterized": {
                return DefaultNamingStrategyProvider::exampleNumberAndPickleIfParameterizedStrategy;
            }
            case "pickle": {
                return DefaultNamingStrategyProvider::pickleNameStrategy;
            }
        }
        throw new IllegalArgumentException("Unrecognized example naming strategy " + exampleStrategy);
    }

    private static NamingStrategy exampleNumberAndPickleIfParameterizedStrategy(BiFunction<Node, String, String> baseStrategy) {
        return DefaultNamingStrategyProvider.createNamingStrategy(node -> (String)baseStrategy.apply((Node)node, DefaultNamingStrategyProvider.nameOrKeyword(node)), (node, pickle) -> (String)baseStrategy.apply((Node)node, DefaultNamingStrategyProvider.nameOrKeyword(node) + DefaultNamingStrategyProvider.pickleNameIfParameterized(node, pickle)));
    }

    private static String pickleNameIfParameterized(Node node, Pickle pickle) {
        if (node instanceof Node.Example) {
            boolean parameterized;
            String pickleName = pickle.getName();
            boolean bl = parameterized = !node.getParent().flatMap(Node::getParent).flatMap(Node::getName).filter(pickleName::equals).isPresent();
            if (parameterized) {
                return ": " + pickleName;
            }
        }
        return "";
    }

    private static NamingStrategy exampleNumberStrategy(BiFunction<Node, String, String> baseStrategy) {
        return DefaultNamingStrategyProvider.createNamingStrategy(node -> (String)baseStrategy.apply((Node)node, DefaultNamingStrategyProvider.nameOrKeyword(node)), (node, pickle) -> (String)baseStrategy.apply((Node)node, DefaultNamingStrategyProvider.nameOrKeyword(node)));
    }

    private static NamingStrategy pickleNameStrategy(BiFunction<Node, String, String> baseStrategy) {
        return DefaultNamingStrategyProvider.createNamingStrategy(node -> (String)baseStrategy.apply((Node)node, DefaultNamingStrategyProvider.nameOrKeyword(node)), (node, pickle) -> (String)baseStrategy.apply((Node)node, pickle.getName()));
    }

    private static NamingStrategy createNamingStrategy(final Function<Node, String> nameFunction, final BiFunction<Node, Pickle, String> exampleNameFunction) {
        return new NamingStrategy(){

            @Override
            public String name(Node node) {
                return (String)nameFunction.apply(node);
            }

            @Override
            public String nameExample(Node node, Pickle pickle) {
                return (String)exampleNameFunction.apply(node, pickle);
            }
        };
    }

    private static String nameOrKeyword(Node node) {
        Supplier<String> keyword = () -> node.getKeyword().orElse("Unknown");
        return node.getName().orElseGet(keyword);
    }

    private static String shortStrategy(Node node, String currentNodeName) {
        return currentNodeName;
    }

    private static String longStrategy(Node node, String currentNodeName) {
        StringBuilder builder = new StringBuilder();
        builder.append(currentNodeName);
        node = node.getParent().orElse(null);
        while (node != null) {
            builder.insert(0, " - ");
            builder.insert(0, DefaultNamingStrategyProvider.nameOrKeyword(node));
            node = node.getParent().orElse(null);
        }
        return builder.toString();
    }

    private static String surefireStrategy(Node node, String currentNodeName) {
        if (node instanceof Node.Examples || node instanceof Node.Rule) {
            return DefaultNamingStrategyProvider.nameOrKeyword(DefaultNamingStrategyProvider.findFeature(node));
        }
        if (node instanceof Node.Scenario || node instanceof Node.Example) {
            return DefaultNamingStrategyProvider.longStrategyWithoutFeatureName(node, currentNodeName);
        }
        return DefaultNamingStrategyProvider.shortStrategy(node, currentNodeName);
    }

    private static String longStrategyWithoutFeatureName(Node node, String currentNodeName) {
        StringBuilder builder = new StringBuilder();
        builder.append(currentNodeName);
        node = node.getParent().orElse(null);
        while (node != null && !(node instanceof Node.Feature)) {
            builder.insert(0, " - ");
            builder.insert(0, DefaultNamingStrategyProvider.nameOrKeyword(node));
            node = node.getParent().orElse(null);
        }
        return builder.toString();
    }

    private static Node findFeature(Node node) {
        Node candidate = node.getParent().orElse(null);
        while (candidate != null) {
            node = candidate;
            candidate = node.getParent().orElse(null);
        }
        return node;
    }
}

