/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.eventbus.Options;
import io.cucumber.core.eventbus.UuidGenerator;
import io.cucumber.core.feature.FeatureIdentifier;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.resource.ClassLoaders;
import io.cucumber.core.resource.ResourceScanner;
import io.cucumber.core.runtime.UuidGeneratorServiceLoader;
import io.cucumber.junit.platform.engine.Cucumber;
import io.cucumber.junit.platform.engine.CucumberConfiguration;
import io.cucumber.junit.platform.engine.CucumberDiscoverySelectors;
import io.cucumber.junit.platform.engine.CucumberTestDescriptor;
import io.cucumber.junit.platform.engine.FeatureParserWithCaching;
import io.cucumber.junit.platform.engine.FeatureParserWithIssueReporting;
import io.cucumber.junit.platform.engine.FeatureParserWithSource;
import io.cucumber.junit.platform.engine.FeatureWithSource;
import io.cucumber.plugin.event.Node;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.junit.platform.commons.io.Resource;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathResourceSelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.FileSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.discovery.UriSelector;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;
import org.junit.platform.engine.support.discovery.SelectorResolver;

final class FeatureFileResolver
implements SelectorResolver {
    private final ResourceScanner<FeatureWithSource> featureScanner;
    private final FeatureParserWithCaching featureParser;
    private final Predicate<String> packageFilter;
    private final DiscoveryIssueReporter issueReporter;
    private final CucumberTestDescriptor.Builder testDescriptorBuilder;

    FeatureFileResolver(CucumberConfiguration configuration, Predicate<String> packageFilter, DiscoveryIssueReporter issueReporter) {
        this.packageFilter = packageFilter;
        this.issueReporter = issueReporter;
        this.featureParser = FeatureFileResolver.createFeatureParser(configuration, issueReporter);
        this.featureScanner = new ResourceScanner(ClassLoaders::getDefaultClassLoader, FeatureIdentifier::isFeature, this.featureParser::parseResource);
        this.testDescriptorBuilder = CucumberTestDescriptor.builder(configuration);
    }

    private static FeatureParserWithCaching createFeatureParser(CucumberConfiguration options, DiscoveryIssueReporter issueReporter) {
        Supplier<ClassLoader> classLoader = FeatureFileResolver.class::getClassLoader;
        UuidGeneratorServiceLoader uuidGeneratorServiceLoader = new UuidGeneratorServiceLoader(classLoader, (Options)options);
        UuidGenerator uuidGenerator = uuidGeneratorServiceLoader.loadUuidGenerator();
        FeatureParser featureParser = new FeatureParser(() -> ((UuidGenerator)uuidGenerator).generateId());
        FeatureParserWithSource featureParserWithSource = new FeatureParserWithSource(featureParser);
        FeatureParserWithIssueReporting featureParserWithIssueReporting = new FeatureParserWithIssueReporting(featureParserWithSource, issueReporter);
        return new FeatureParserWithCaching(featureParserWithIssueReporting);
    }

    public SelectorResolver.Resolution resolve(DiscoverySelector selector, SelectorResolver.Context context) {
        if (selector instanceof CucumberDiscoverySelectors.FeatureElementSelector) {
            return this.resolve((CucumberDiscoverySelectors.FeatureElementSelector)selector, context);
        }
        if (selector instanceof CucumberDiscoverySelectors.FeatureWithLinesSelector) {
            return this.resolve((CucumberDiscoverySelectors.FeatureWithLinesSelector)selector);
        }
        return super.resolve(selector, context);
    }

    public SelectorResolver.Resolution resolve(CucumberDiscoverySelectors.FeatureElementSelector selector, SelectorResolver.Context context) {
        FeatureWithSource feature = selector.getFeature();
        Node selected = selector.getElement();
        return selected.getParent().map(parent -> context.addToParent(() -> CucumberDiscoverySelectors.FeatureElementSelector.selectElement(feature, parent), this.createTestDescriptor(feature, selected))).orElseGet(() -> context.addToParent(this.createTestDescriptor(feature, selected))).map(descriptor -> SelectorResolver.Match.exact((TestDescriptor)descriptor, () -> CucumberDiscoverySelectors.FeatureElementSelector.selectElementsOf(feature, selected))).map(SelectorResolver.Resolution::match).orElseGet(SelectorResolver.Resolution::unresolved);
    }

    private Function<TestDescriptor, Optional<TestDescriptor>> createTestDescriptor(FeatureWithSource feature, Node selected) {
        return parent -> this.testDescriptorBuilder.build((TestDescriptor)parent, feature, selected);
    }

    public SelectorResolver.Resolution resolve(CucumberDiscoverySelectors.FeatureWithLinesSelector selector) {
        URI uri = selector.getUri();
        Set selectors = this.featureScanner.scanForResourcesUri(uri).stream().flatMap(feature -> CucumberDiscoverySelectors.FeatureElementSelector.selectElementsAt(feature, selector::getFilePositions, this.issueReporter)).collect(Collectors.toSet());
        return FeatureFileResolver.toResolution(selectors);
    }

    public SelectorResolver.Resolution resolve(FileSelector selector, SelectorResolver.Context context) {
        Path path = selector.getPath();
        if (!FeatureIdentifier.isFeature((Path)path)) {
            return SelectorResolver.Resolution.unresolved();
        }
        Set selectors = this.featureParser.parseResource(path).map(feature -> CucumberDiscoverySelectors.FeatureElementSelector.selectElementAt(feature, () -> ((FileSelector)selector).getPosition(), this.issueReporter)).map(Collections::singleton).orElseGet(Collections::emptySet);
        return FeatureFileResolver.toResolution(selectors);
    }

    public SelectorResolver.Resolution resolve(ClasspathResourceSelector selector, SelectorResolver.Context context) {
        Set resources = selector.getClasspathResources();
        if (!resources.stream().allMatch(resource -> FeatureIdentifier.isFeature((String)resource.getName()))) {
            return this.resolveClasspathResourceSelectorAsPackageSelector(selector);
        }
        if (resources.size() > 1) {
            throw new IllegalArgumentException(String.format("Found %s resources named %s on the classpath %s.", resources.size(), selector.getClasspathResourceName(), resources.stream().map(Resource::getUri).collect(Collectors.toList())));
        }
        return resources.stream().findFirst().filter(resource -> FeatureIdentifier.isFeature((String)resource.getName())).flatMap(this.featureParser::parseResource).map(feature -> CucumberDiscoverySelectors.FeatureElementSelector.selectElementAt(feature, () -> ((ClasspathResourceSelector)selector).getPosition(), this.issueReporter)).map(Collections::singleton).map(FeatureFileResolver::toResolution).orElseGet(SelectorResolver.Resolution::unresolved);
    }

    @Deprecated
    private SelectorResolver.Resolution resolveClasspathResourceSelectorAsPackageSelector(ClasspathResourceSelector selector) {
        Set selectors = this.featureScanner.scanForClasspathResource(selector.getClasspathResourceName(), this.packageFilter).stream().map(feature -> CucumberDiscoverySelectors.FeatureElementSelector.selectElementAt(feature, () -> ((ClasspathResourceSelector)selector).getPosition(), this.issueReporter)).collect(Collectors.toSet());
        this.warnClasspathResourceSelectorUsedForPackage(selector);
        return FeatureFileResolver.toResolution(selectors);
    }

    private void warnClasspathResourceSelectorUsedForPackage(ClasspathResourceSelector selector) {
        String classpathResourceName = selector.getClasspathResourceName();
        String packageName = classpathResourceName.replaceAll("/", ".");
        String message = String.format("The classpath resource selector '%s' should not be used to select features in a package. Use the package selector with '%s' instead", classpathResourceName, packageName);
        this.issueReporter.reportIssue(DiscoveryIssue.builder((DiscoveryIssue.Severity)DiscoveryIssue.Severity.WARNING, (String)message));
    }

    public SelectorResolver.Resolution resolve(UriSelector selector, SelectorResolver.Context context) {
        URI uri = selector.getUri();
        Set<CucumberDiscoverySelectors.FeatureWithLinesSelector> selectors = Collections.singleton(CucumberDiscoverySelectors.FeatureWithLinesSelector.from(uri));
        return FeatureFileResolver.toResolution(selectors);
    }

    public SelectorResolver.Resolution resolve(ClassSelector selector, SelectorResolver.Context context) {
        Class javaClass = selector.getJavaClass();
        Cucumber annotation = javaClass.getAnnotation(Cucumber.class);
        if (annotation != null) {
            this.warnAboutDeprecatedCucumberClass(javaClass);
            String packageName = javaClass.getPackage().getName();
            Set<PackageSelector> selectors = Collections.singleton(DiscoverySelectors.selectPackage((String)packageName));
            return FeatureFileResolver.toResolution(selectors);
        }
        return SelectorResolver.Resolution.unresolved();
    }

    private void warnAboutDeprecatedCucumberClass(Class<?> javaClass) {
        String message = "The @Cucumber annotation has been deprecated. See the Javadoc for more details.";
        DiscoveryIssue issue = DiscoveryIssue.builder((DiscoveryIssue.Severity)DiscoveryIssue.Severity.WARNING, (String)message).source((TestSource)ClassSource.from(javaClass)).build();
        this.issueReporter.reportIssue(issue);
    }

    public SelectorResolver.Resolution resolve(UniqueIdSelector selector, SelectorResolver.Context context) {
        UniqueId uniqueId = selector.getUniqueId();
        Set<CucumberDiscoverySelectors.FeatureWithLinesSelector> selectors = CucumberDiscoverySelectors.FeatureWithLinesSelector.from(uniqueId);
        return FeatureFileResolver.toResolution(selectors);
    }

    private static SelectorResolver.Resolution toResolution(Set<? extends DiscoverySelector> selectors) {
        if (selectors.isEmpty()) {
            return SelectorResolver.Resolution.unresolved();
        }
        return SelectorResolver.Resolution.selectors(selectors);
    }
}

