/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit;

import android.util.Pair;
import cucumber.runtime.CucumberException;
import io.cucumber.junit.TestRuleAccessor;
import io.cucumber.junit.TestRulesData;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestRulesExecutor {
    private final List<TestRulesData> rulesHolders;
    private CountDownLatch wrappedStatementLatch = new CountDownLatch(1);
    private CountDownLatch rulesExecutionLatch = new CountDownLatch(1);
    private ExecutorService executorService;
    private Future<?> rulesFuture;

    public TestRulesExecutor(List<TestRulesData> rulesHolders, ExecutorService executorService) {
        this.rulesHolders = rulesHolders;
        this.executorService = executorService;
    }

    public void startRules(Description description) {
        if (this.rulesHolders.isEmpty()) {
            return;
        }
        AtomicReference<Throwable> throwable = new AtomicReference<Throwable>();
        try {
            ArrayList<Pair<Integer, TestRule>> rulesWithOrders = new ArrayList<Pair<Integer, TestRule>>(this.rulesHolders.size());
            for (TestRulesData rulesData : this.rulesHolders) {
                Object obj = rulesData.getDeclaringObject();
                List<TestRuleAccessor> accessors = rulesData.getAccessors();
                for (TestRuleAccessor accessor : accessors) {
                    TestRule rule = this.getTestRule(rulesData, obj, accessor);
                    rulesWithOrders.add((Pair<Integer, TestRule>)Pair.create((Object)accessor.getOrder(), (Object)rule));
                }
            }
            List<TestRule> rules = TestRulesExecutor.getTestRules(rulesWithOrders);
            this.rulesFuture = this.executorService.submit(this.getTask(description, throwable, rules));
            this.rulesExecutionLatch.await();
        }
        catch (Throwable e) {
            throw new CucumberException(e);
        }
        if (throwable.get() != null) {
            throw new CucumberException(throwable.get());
        }
    }

    private Runnable getTask(final Description description, final AtomicReference<Throwable> throwable, final List<TestRule> rules) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    RunRules runRules = new RunRules(new Statement(){

                        public void evaluate() throws Throwable {
                            TestRulesExecutor.this.rulesExecutionLatch.countDown();
                            TestRulesExecutor.this.wrappedStatementLatch.await();
                        }
                    }, (Iterable)rules, description);
                    runRules.evaluate();
                }
                catch (Throwable t) {
                    if (TestRulesExecutor.this.rulesExecutionLatch.getCount() != 0L) {
                        TestRulesExecutor.this.rulesExecutionLatch.countDown();
                    }
                    throwable.set(t);
                }
            }
        };
    }

    private TestRule getTestRule(TestRulesData rulesData, Object obj, TestRuleAccessor accessor) throws IllegalAccessException, InvocationTargetException {
        TestRule rule = accessor.getRule(obj);
        if (rulesData.useAsTestClassInDescription()) {
            TestRule finalRule = rule;
            rule = (base, description1) -> finalRule.apply(base, Description.createTestDescription(rulesData.getDeclaringClass(), (String)description1.getMethodName()));
        }
        return rule;
    }

    private static List<TestRule> getTestRules(List<Pair<Integer, TestRule>> rulesWithOrders) {
        Collections.sort(rulesWithOrders, (o1, o2) -> ((Integer)o1.first).compareTo((Integer)o2.first));
        ArrayList<TestRule> rules = new ArrayList<TestRule>(rulesWithOrders.size());
        for (Pair<Integer, TestRule> rule : rulesWithOrders) {
            rules.add((TestRule)rule.second);
        }
        return rules;
    }

    public void stopRules() {
        if (this.rulesFuture == null) {
            return;
        }
        this.wrappedStatementLatch.countDown();
        try {
            this.rulesFuture.get();
        }
        catch (ExecutionException e) {
            throw new CucumberException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new CucumberException((Throwable)e);
        }
    }
}

