/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit;

import cucumber.runner.RunnerSupplier;
import cucumber.runner.ThreadLocalRunnerSupplier;
import cucumber.runtime.CucumberException;
import cucumber.runtime.filter.Filters;
import cucumber.runtime.model.CucumberFeature;
import gherkin.ast.Feature;
import gherkin.events.PickleEvent;
import io.cucumber.junit.JUnitOptions;
import io.cucumber.junit.PickleRunners;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

final class FeatureRunner
extends ParentRunner<PickleRunners.PickleRunner> {
    private final List<PickleRunners.PickleRunner> children = new ArrayList<PickleRunners.PickleRunner>();
    private final CucumberFeature cucumberFeature;
    private Description description;

    FeatureRunner(CucumberFeature cucumberFeature, Filters filters, ThreadLocalRunnerSupplier runnerSupplier, JUnitOptions jUnitOptions) throws InitializationError {
        super(null);
        this.cucumberFeature = cucumberFeature;
        this.buildFeatureElementRunners(filters, runnerSupplier, jUnitOptions);
    }

    protected String getName() {
        Feature feature = this.cucumberFeature.getGherkinFeature().getFeature();
        return feature.getKeyword() + ": " + feature.getName();
    }

    public Description getDescription() {
        if (this.description == null) {
            this.description = Description.createSuiteDescription((String)this.getName(), (Serializable)new FeatureId(this.cucumberFeature), (Annotation[])new Annotation[0]);
            for (PickleRunners.PickleRunner child : this.getChildren()) {
                this.description.addChild(this.describeChild(child));
            }
        }
        return this.description;
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    protected List<PickleRunners.PickleRunner> getChildren() {
        return this.children;
    }

    protected Description describeChild(PickleRunners.PickleRunner child) {
        return child.getDescription();
    }

    protected void runChild(PickleRunners.PickleRunner child, RunNotifier notifier) {
        child.run(notifier);
    }

    private void buildFeatureElementRunners(Filters filters, ThreadLocalRunnerSupplier runnerSupplier, JUnitOptions jUnitOptions) {
        for (PickleEvent pickleEvent : this.cucumberFeature.getPickles()) {
            if (!filters.matchesFilters(pickleEvent)) continue;
            try {
                PickleRunners.PickleRunner picklePickleRunner;
                if (jUnitOptions.stepNotifications()) {
                    picklePickleRunner = PickleRunners.withStepDescriptions((RunnerSupplier)runnerSupplier, pickleEvent, jUnitOptions);
                    this.children.add(picklePickleRunner);
                    continue;
                }
                picklePickleRunner = PickleRunners.withNoStepDescriptions(this.cucumberFeature.getName(), (RunnerSupplier)runnerSupplier, pickleEvent, jUnitOptions);
                this.children.add(picklePickleRunner);
            }
            catch (InitializationError e) {
                throw new CucumberException("Failed to create scenario runner", (Throwable)e);
            }
        }
    }

    private static final class FeatureId
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final URI uri;

        FeatureId(CucumberFeature feature) {
            this.uri = feature.getUri();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeatureId featureId = (FeatureId)o;
            return this.uri.equals(featureId.uri);
        }

        public int hashCode() {
            return this.uri.hashCode();
        }

        public String toString() {
            return this.uri.toString();
        }
    }
}

