/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit;

import cucumber.runtime.CucumberException;
import cucumber.util.FixJava;
import io.cucumber.junit.CucumberOptions;
import io.cucumber.junit.JUnitOptionsBuilder;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

final class JUnitOptionsParser {
    private static final String OPTIONS_RESOURCE = "/io/cucumber/junit/api/OPTIONS.txt";
    private static String optionsText;

    JUnitOptionsParser() {
    }

    JUnitOptionsBuilder parse(List<String> args) {
        args = new ArrayList<String>(args);
        JUnitOptionsBuilder builder = new JUnitOptionsBuilder();
        while (!args.isEmpty()) {
            String arg = args.remove(0).trim();
            if (arg.equals("--help") || arg.equals("-h")) {
                this.printOptions();
                System.exit(0);
                continue;
            }
            if (arg.equals("--no-filename-compatible-names") || arg.equals("--filename-compatible-names")) {
                builder.setFilenameCompatibleNames(!arg.startsWith("--no-"));
                continue;
            }
            if (arg.equals("--no-step-notifications") || arg.equals("--step-notifications")) {
                builder.setStepNotifications(!arg.startsWith("--no-"));
                continue;
            }
            this.printOptions();
            throw new CucumberException("Unknown option: " + arg);
        }
        return builder;
    }

    JUnitOptionsBuilder parse(Class<?> clazz) {
        JUnitOptionsBuilder args = new JUnitOptionsBuilder();
        for (Class<?> classWithOptions = clazz; classWithOptions != Object.class; classWithOptions = classWithOptions.getSuperclass()) {
            CucumberOptions options = classWithOptions.getAnnotation(CucumberOptions.class);
            if (options == null) continue;
            if (options.stepNotifications()) {
                args.setStepNotifications(true);
            }
            if (!options.useFileNameCompatibleName()) continue;
            args.setFilenameCompatibleNames(true);
        }
        return args;
    }

    private void printOptions() {
        JUnitOptionsParser.loadUsageTextIfNeeded();
        System.out.println(optionsText);
    }

    private static void loadUsageTextIfNeeded() {
        if (optionsText == null) {
            try {
                InputStreamReader reader = new InputStreamReader(FixJava.class.getResourceAsStream(OPTIONS_RESOURCE), "UTF-8");
                optionsText = FixJava.readReader((Reader)reader);
            }
            catch (Exception e) {
                optionsText = "Could not load usage text: " + e.toString();
            }
        }
    }
}

