package io.cucumber.junit;

final class FileNameCompatibleNames {
    static String createName(final String name, boolean useFilenameCompatibleNames) {
        if (useFilenameCompatibleNames) {
            return makeNameFilenameCompatible(name);
        }

        return name;
    }

    private static String makeNameFilenameCompatible(String name) {
        return name.replaceAll("[^A-Za-z0-9_]", "_");
    }
}
