/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.jython;

import cucumber.api.DataTable;
import cucumber.api.Scenario;
import cucumber.runtime.Backend;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Glue;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.UnreportedStepExecutor;
import cucumber.runtime.io.Resource;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.jython.JythonHookDefinition;
import cucumber.runtime.jython.JythonSnippet;
import cucumber.runtime.jython.JythonStepDefinition;
import cucumber.runtime.snippets.FunctionNameGenerator;
import cucumber.runtime.snippets.Snippet;
import cucumber.runtime.snippets.SnippetGenerator;
import gherkin.pickles.PickleStep;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyInstance;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.util.PythonInterpreter;

public class JythonBackend
implements Backend {
    private final SnippetGenerator snippetGenerator = new SnippetGenerator((Snippet)new JythonSnippet());
    private final ResourceLoader resourceLoader;
    private final PythonInterpreter jython;
    private PyObject pyWorld;
    private Glue glue;

    public JythonBackend(ResourceLoader resourceLoader, PythonInterpreter jython) {
        this.resourceLoader = resourceLoader;
        this.jython = jython;
        jython.set("backend", (Object)this);
        for (Resource resource : resourceLoader.resources("classpath:cucumber/runtime/jython", "dsl.py")) {
            this.runScript(resource);
        }
    }

    public JythonBackend(ResourceLoader resourceLoader) {
        this(resourceLoader, new PythonInterpreter());
    }

    public void loadGlue(Glue glue, List<String> gluePaths) {
        this.glue = glue;
        for (String gluePath : gluePaths) {
            for (Resource resource : this.resourceLoader.resources(gluePath, ".py")) {
                this.runScript(resource);
            }
        }
    }

    public void setUnreportedStepExecutor(UnreportedStepExecutor executor) {
    }

    public void buildWorld() {
        this.pyWorld = this.jython.eval("World()");
    }

    private void runScript(Resource resource) {
        try {
            this.jython.execfile(resource.getInputStream(), resource.getAbsolutePath());
        }
        catch (IOException e) {
            throw new CucumberException((Throwable)e);
        }
    }

    public void disposeWorld() {
    }

    public String getSnippet(PickleStep step, String keyword, FunctionNameGenerator functionNameGenerator) {
        return this.snippetGenerator.getSnippet(step, keyword, functionNameGenerator);
    }

    public void registerStepdef(PyInstance stepdef, int arity) {
        this.glue.addStepDefinition((StepDefinition)new JythonStepDefinition(this, stepdef, arity));
    }

    public void addBeforeHook(PyInstance hookDefinition) {
        this.glue.addBeforeHook((HookDefinition)new JythonHookDefinition(this, hookDefinition));
    }

    public void addAfterHook(PyInstance hookDefinition) {
        this.glue.addAfterHook((HookDefinition)new JythonHookDefinition(this, hookDefinition));
    }

    public void executeHook(PyInstance hookDefinition, Scenario scenario) {
        try {
            hookDefinition.invoke("execute", this.pyWorld, Py.java2py((Object)scenario));
        }
        catch (PyException e) {
            if (this.getStacktrace(e).contains("takes exactly 1 argument (2 given)")) {
                hookDefinition.invoke("execute", this.pyWorld);
            }
            throw e;
        }
    }

    private String getStacktrace(PyException e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    private PyObject argToPyObject(Object arg) {
        if (arg instanceof DataTable) {
            return this.dataTableToPyArray((DataTable)arg);
        }
        return new PyString((String)arg);
    }

    private PyObject dataTableToPyArray(DataTable table) {
        PyList pyTable = new PyList();
        for (List row : table.raw()) {
            PyList pyRow = new PyList();
            for (String cell : row) {
                pyRow.append((PyObject)new PyString(cell));
            }
            pyTable.append((PyObject)pyRow);
        }
        return pyTable;
    }

    public void execute(PyInstance stepdef, Object[] args) throws Throwable {
        PyObject[] pyArgs = new PyObject[args.length + 1];
        pyArgs[0] = this.pyWorld;
        for (int i = 0; i < args.length; ++i) {
            pyArgs[i + 1] = this.argToPyObject(args[i]);
        }
        try {
            stepdef.invoke("execute", pyArgs);
        }
        catch (PyException t) {
            Object unwrapped = t.value.__tojava__(Object.class);
            if (unwrapped instanceof Throwable) {
                throw (Throwable)unwrapped;
            }
            throw t.getCause() == null ? t : t.getCause();
        }
    }
}

