/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.jython;

import cucumber.runtime.Argument;
import cucumber.runtime.ParameterInfo;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.jython.JythonBackend;
import gherkin.pickles.PickleStep;
import java.lang.reflect.Type;
import java.util.List;
import org.python.core.PyInstance;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;

public class JythonStepDefinition
implements StepDefinition {
    private final JythonBackend jythonBackend;
    private final PyInstance stepdef;
    private final int arity;

    public JythonStepDefinition(JythonBackend jythonBackend, PyInstance stepdef, int arity) {
        this.jythonBackend = jythonBackend;
        this.stepdef = stepdef;
        this.arity = arity;
    }

    public List<Argument> matchedArguments(PickleStep step) {
        PyString stepText = new PyString(step.getText());
        PyObject matched_arguments = this.stepdef.invoke("matched_arguments", (PyObject)stepText);
        if (matched_arguments instanceof PyList) {
            return (PyList)matched_arguments;
        }
        return null;
    }

    public String getLocation(boolean detail) {
        return null;
    }

    public Integer getParameterCount() {
        return this.arity;
    }

    public ParameterInfo getParameterType(int n, Type argumentType) {
        return new ParameterInfo(argumentType, null, null, null);
    }

    public void execute(String language, Object[] args) throws Throwable {
        this.jythonBackend.execute(this.stepdef, args);
    }

    public boolean isDefinedAt(StackTraceElement stackTraceElement) {
        return false;
    }

    public String getPattern() {
        return this.stepdef.invoke("pattern").toString();
    }

    public boolean isScenarioScoped() {
        return false;
    }
}

