/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.needle;

import de.akquinet.jbosscc.needle.injection.InjectionProvider;
import de.akquinet.jbosscc.needle.reflection.ReflectionUtil;
import io.cucumber.needle.InjectionProviderInstancesSupplier;
import io.cucumber.needle.NeedleFactory;
import io.cucumber.needle.NeedleInjectionProvider;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum CollectInjectionProvidersFromStepsInstance {
    INSTANCE;

    private final Logger logger = LoggerFactory.getLogger(NeedleFactory.class);

    final <T> InjectionProvider<?>[] apply(T instance) {
        LinkedHashSet<Object> providers = new LinkedHashSet<Object>();
        for (Field field : ReflectionUtil.getAllFieldsWithAnnotation(instance, NeedleInjectionProvider.class)) {
            field.setAccessible(true);
            try {
                Object value = field.get(instance);
                if (value instanceof InjectionProvider[]) {
                    providers.addAll(Arrays.asList((InjectionProvider[])value));
                    continue;
                }
                if (value instanceof InjectionProvider) {
                    providers.add((InjectionProvider)value);
                    continue;
                }
                if (value instanceof InjectionProviderInstancesSupplier) {
                    providers.addAll(((InjectionProviderInstancesSupplier)value).get());
                    continue;
                }
                throw new IllegalStateException("Fields annotated with NeedleInjectionProviders must be of type InjectionProviderInstancesSupplier, InjectionProvider or InjectionProvider[]");
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Adding {} InjectionProvider instances.", (Object)providers.size());
        }
        return providers.toArray(new InjectionProvider[0]);
    }
}

