/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.needle;

import de.akquinet.jbosscc.needle.injection.InjectionProvider;
import io.cucumber.needle.CreateInstanceByDefaultConstructor;
import io.cucumber.needle.InjectionProviderInstancesSupplier;
import io.cucumber.needle.LoadResourceBundle;
import io.cucumber.needle.ReadInjectionProviderClassNames;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;

class CucumberNeedleConfiguration {
    static final String RESOURCE_CUCUMBER_NEEDLE = "cucumber-needle";
    private final Set<InjectionProvider<?>> injectionProviders = new HashSet();

    CucumberNeedleConfiguration() {
        this(RESOURCE_CUCUMBER_NEEDLE);
    }

    CucumberNeedleConfiguration(String resourceName) {
        ResourceBundle resourceBundle = LoadResourceBundle.INSTANCE.apply(resourceName);
        Set<String> classNames = ReadInjectionProviderClassNames.INSTANCE.apply(resourceBundle);
        for (String className : classNames) {
            try {
                InjectionProviderInstancesSupplier supplier;
                Set<InjectionProvider<?>> providers;
                Class<?> clazz = Class.forName(className);
                CreateInstanceByDefaultConstructor createInstance = CreateInstanceByDefaultConstructor.INSTANCE;
                if (CucumberNeedleConfiguration.isInjectionProvider(clazz)) {
                    this.injectionProviders.add((InjectionProvider)createInstance.apply(clazz));
                    continue;
                }
                if (!CucumberNeedleConfiguration.isInjectionProviderInstanceSupplier(clazz) || (providers = (supplier = (InjectionProviderInstancesSupplier)createInstance.apply(clazz)).get()) == null) continue;
                this.injectionProviders.addAll(providers);
            }
            catch (Exception e) {
                throw new IllegalStateException("failed to initialize custom injection providers", e);
            }
        }
    }

    static boolean isInjectionProvider(Class<?> type) {
        return InjectionProvider.class.isAssignableFrom(type);
    }

    static boolean isInjectionProviderInstanceSupplier(Class<?> type) {
        return InjectionProviderInstancesSupplier.class.isAssignableFrom(type);
    }

    InjectionProvider<?>[] getInjectionProviders() {
        return this.injectionProviders.toArray(new InjectionProvider[0]);
    }
}

