/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.needle;

import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum LoadResourceBundle {
    INSTANCE;

    public static final ResourceBundle EMPTY_RESOURCE_BUNDLE;
    private final Logger logger = LoggerFactory.getLogger(LoadResourceBundle.class);

    public final ResourceBundle apply(String resourceName) {
        if (resourceName == null || "".equals(resourceName.trim())) {
            throw new IllegalArgumentException("resourceName must not be null or empty!");
        }
        try {
            return ResourceBundle.getBundle(resourceName);
        }
        catch (MissingResourceException e) {
            this.logger.warn(e.getMessage());
            return EMPTY_RESOURCE_BUNDLE;
        }
    }

    static {
        EMPTY_RESOURCE_BUNDLE = new ResourceBundle(){

            @Override
            protected Object handleGetObject(String key) {
                return "";
            }

            @Override
            public Enumeration<String> getKeys() {
                return new Enumeration<String>(){

                    @Override
                    public boolean hasMoreElements() {
                        return false;
                    }

                    @Override
                    public String nextElement() {
                        return null;
                    }
                };
            }
        };
    }
}

