/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.needle;

import de.akquinet.jbosscc.needle.NeedleTestcase;
import de.akquinet.jbosscc.needle.injection.InjectionProvider;
import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.needle.CollectInjectionProvidersFromStepsInstance;
import io.cucumber.needle.CreateInstanceByDefaultConstructor;
import io.cucumber.needle.CucumberNeedleConfiguration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE)
public final class NeedleFactory
extends NeedleTestcase
implements ObjectFactory {
    private final Map<Class<?>, Object> cachedStepsInstances = new LinkedHashMap();
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final CreateInstanceByDefaultConstructor createInstanceByDefaultConstructor = CreateInstanceByDefaultConstructor.INSTANCE;
    private final CollectInjectionProvidersFromStepsInstance collectInjectionProvidersFromStepsInstance = CollectInjectionProvidersFromStepsInstance.INSTANCE;

    public NeedleFactory() {
        super(NeedleFactory.setUpInjectionProviders());
    }

    static InjectionProvider<?>[] setUpInjectionProviders() {
        return new CucumberNeedleConfiguration().getInjectionProviders();
    }

    public <T> T getInstance(Class<T> type) {
        this.logger.warn("cucumber-needle has been deprecated. Consider using cucumber-cdi2 or cucumber-jakarta-cdi");
        this.logger.trace("getInstance: {}", (Object)type.getCanonicalName());
        this.assertTypeHasBeenAdded(type);
        return this.nullSafeGetInstance(type);
    }

    private void assertTypeHasBeenAdded(Class<?> type) {
        if (!this.cachedStepsInstances.containsKey(type)) {
            throw new IllegalStateException(String.format("%s was not added during addClass()", type.getSimpleName()));
        }
    }

    private <T> T nullSafeGetInstance(Class<T> type) {
        Object instance = this.cachedStepsInstances.get(type);
        if (instance == null) {
            throw new IllegalStateException(String.format("instance of type %s has not been initialized in start()!", type.getSimpleName()));
        }
        return (T)instance;
    }

    public void start() {
        this.logger.trace("start()");
        try {
            this.cachedStepsInstances.replaceAll((t, v) -> this.createStepsInstance((Class)t));
            for (Object stepsInstance : this.cachedStepsInstances.values()) {
                this.addInjectionProvider(this.collectInjectionProvidersFromStepsInstance.apply(stepsInstance));
            }
            for (Object stepsInstance : this.cachedStepsInstances.values()) {
                this.initTestcase(stepsInstance);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void stop() {
        this.logger.trace("stop()");
        this.cachedStepsInstances.replaceAll((t, v) -> null);
    }

    private <T> T createStepsInstance(Class<T> type) {
        this.logger.trace("createInstance(): {}", (Object)type.getCanonicalName());
        return this.createInstanceByDefaultConstructor.apply(type);
    }

    public boolean addClass(Class<?> type) {
        this.logger.trace("addClass(): {}", (Object)type.getCanonicalName());
        if (!this.cachedStepsInstances.containsKey(type)) {
            this.cachedStepsInstances.put(type, null);
        }
        return true;
    }
}

