/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.picocontainer;

import io.cucumber.core.backend.ObjectFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.apiguardian.api.API;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoBuilder;
import org.picocontainer.behaviors.Cached;
import org.picocontainer.lifecycle.DefaultLifecycleState;
import org.picocontainer.lifecycle.LifecycleState;

@API(status=API.Status.STABLE)
public final class PicoFactory
implements ObjectFactory {
    private final Set<Class<?>> classes = new HashSet();
    private MutablePicoContainer pico;

    private static boolean isInstantiable(Class<?> clazz) {
        boolean isNonStaticInnerClass = !Modifier.isStatic(clazz.getModifiers()) && clazz.getEnclosingClass() != null;
        return Modifier.isPublic(clazz.getModifiers()) && !Modifier.isAbstract(clazz.getModifiers()) && !isNonStaticInnerClass;
    }

    public void start() {
        if (this.pico == null) {
            this.pico = new PicoBuilder().withCaching().withLifecycle().build();
            for (Class<?> clazz : this.classes) {
                this.pico.addComponent(clazz);
            }
        } else {
            this.pico.setLifecycleState((LifecycleState)new DefaultLifecycleState());
            this.pico.getComponentAdapters().forEach(cached -> ((Cached)cached).flush());
        }
        this.pico.start();
    }

    public void stop() {
        this.pico.stop();
        this.pico.dispose();
    }

    public boolean addClass(Class<?> clazz) {
        if (PicoFactory.isInstantiable(clazz) && this.classes.add(clazz)) {
            this.addConstructorDependencies(clazz);
        }
        return true;
    }

    public <T> T getInstance(Class<T> type) {
        return (T)this.pico.getComponent(type);
    }

    private void addConstructorDependencies(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            for (Class<?> paramClazz : constructor.getParameterTypes()) {
                this.addClass(paramClazz);
            }
        }
    }
}

