/*
 * Decompiled with CFR 0.152.
 */
package cucumber.api.testng;

import cucumber.api.Result;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.runtime.CucumberException;
import org.testng.SkipException;

class TestCaseResultListener
implements EventListener {
    static final String UNDEFINED_MESSAGE = "There are undefined steps";
    static final String SKIPPED_MESSAGE = "This scenario is skipped";
    private boolean strict;
    private Result result;
    private final EventHandler<TestCaseFinished> testCaseFinishedHandler = new EventHandler<TestCaseFinished>(){

        public void receive(TestCaseFinished event) {
            TestCaseResultListener.this.receiveResult(event.result);
        }
    };

    TestCaseResultListener(boolean strict) {
        this.strict = strict;
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestCaseFinished.class, this.testCaseFinishedHandler);
    }

    void receiveResult(Result result) {
        this.result = result;
    }

    boolean isPassed() {
        return this.result == null || this.result.is(Result.Type.PASSED);
    }

    Throwable getError() {
        if (this.result == null) {
            return null;
        }
        switch (this.result.getStatus()) {
            case FAILED: 
            case AMBIGUOUS: {
                return this.result.getError();
            }
            case PENDING: {
                if (this.strict) {
                    return this.result.getError();
                }
                return new SkipException(this.result.getErrorMessage(), this.result.getError());
            }
            case UNDEFINED: {
                if (this.strict) {
                    return new CucumberException(UNDEFINED_MESSAGE);
                }
                return new SkipException(UNDEFINED_MESSAGE);
            }
            case SKIPPED: {
                Throwable error = this.result.getError();
                if (error != null) {
                    if (error instanceof SkipException) {
                        return error;
                    }
                    return new SkipException(this.result.getErrorMessage(), error);
                }
                return new SkipException(SKIPPED_MESSAGE);
            }
            case PASSED: {
                return null;
            }
        }
        throw new IllegalStateException("Unexpected result status: " + this.result.getStatus());
    }

    void startPickle() {
        this.result = null;
    }
}

