/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.datatable;

import io.cucumber.datatable.DataTableType;
import io.cucumber.datatable.DuplicateTypeException;
import io.cucumber.datatable.NumberParser;
import io.cucumber.datatable.TableCellTransformer;
import io.cucumber.datatable.TypeFactory;
import io.cucumber.datatable.dependency.com.fasterxml.jackson.databind.JavaType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;

public final class DataTableTypeRegistry {
    private final HashMap<JavaType, DataTableType> tableTypeByType = new HashMap();

    public DataTableTypeRegistry(Locale locale) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        final NumberParser numberParser = new NumberParser(numberFormat);
        this.defineDataTableType(new DataTableType(BigInteger.class, new TableCellTransformer<BigInteger>(){

            @Override
            public BigInteger transform(String cell) {
                return new BigInteger(cell);
            }
        }));
        this.defineDataTableType(new DataTableType(BigDecimal.class, new TableCellTransformer<BigDecimal>(){

            @Override
            public BigDecimal transform(String cell) {
                return new BigDecimal(cell);
            }
        }));
        this.defineDataTableType(new DataTableType(Byte.class, new TableCellTransformer<Byte>(){

            @Override
            public Byte transform(String cell) {
                return Byte.decode(cell);
            }
        }));
        this.defineDataTableType(new DataTableType(Short.class, new TableCellTransformer<Short>(){

            @Override
            public Short transform(String cell) {
                return Short.decode(cell);
            }
        }));
        this.defineDataTableType(new DataTableType(Integer.class, new TableCellTransformer<Integer>(){

            @Override
            public Integer transform(String cell) {
                return Integer.decode(cell);
            }
        }));
        this.defineDataTableType(new DataTableType(Long.class, new TableCellTransformer<Long>(){

            @Override
            public Long transform(String cell) {
                return Long.decode(cell);
            }
        }));
        this.defineDataTableType(new DataTableType(Float.class, new TableCellTransformer<Float>(){

            @Override
            public Float transform(String cell) {
                return Float.valueOf(numberParser.parseFloat(cell));
            }
        }));
        this.defineDataTableType(new DataTableType(Double.class, new TableCellTransformer<Double>(){

            @Override
            public Double transform(String cell) {
                return numberParser.parseDouble(cell);
            }
        }));
        this.defineDataTableType(new DataTableType(String.class, new TableCellTransformer<String>(){

            @Override
            public String transform(String cell) {
                return cell;
            }
        }));
    }

    public void defineDataTableType(DataTableType dataTableType) {
        DataTableType existing = this.tableTypeByType.get(dataTableType.getTargetType());
        if (existing != null) {
            throw new DuplicateTypeException(String.format("There is already a data table type registered for %s.\nIt registered an %s. You are trying to add a %s", dataTableType.getElementType(), dataTableType.getTransformerType().getSimpleName(), existing.getTransformerType().getSimpleName()));
        }
        this.tableTypeByType.put(dataTableType.getTargetType(), dataTableType);
    }

    public DataTableType lookupTableTypeByType(Type tableType) {
        return this.tableTypeByType.get(TypeFactory.constructType(tableType));
    }
}

