/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junitxmlformatter;

import io.cucumber.junitxmlformatter.GherkingAstNodes;
import io.cucumber.messages.Convertor;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.TableRow;
import io.cucumber.messages.types.TestCase;
import io.cucumber.messages.types.TestCaseFinished;
import io.cucumber.messages.types.TestCaseStarted;
import io.cucumber.messages.types.TestRunFinished;
import io.cucumber.messages.types.TestRunStarted;
import io.cucumber.messages.types.TestStep;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.messages.types.TestStepResult;
import io.cucumber.messages.types.Timestamp;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

class Query {
    private final Comparator<TestStepResult> testStepResultComparator = Comparator.nullsFirst(Comparator.comparing(o -> o.getStatus().ordinal()));
    private final Deque<TestCaseStarted> testCaseStarted = new ConcurrentLinkedDeque<TestCaseStarted>();
    private final Map<String, TestCaseFinished> testCaseFinishedByTestCaseStartedId = new ConcurrentHashMap<String, TestCaseFinished>();
    private final Map<String, List<TestStepFinished>> testStepsFinishedByTestCaseStartedId = new ConcurrentHashMap<String, List<TestStepFinished>>();
    private final Map<String, Pickle> pickleById = new ConcurrentHashMap<String, Pickle>();
    private final Map<String, TestCase> testCaseById = new ConcurrentHashMap<String, TestCase>();
    private final Map<String, Step> stepById = new ConcurrentHashMap<String, Step>();
    private final Map<String, TestStep> testStepById = new ConcurrentHashMap<String, TestStep>();
    private final Map<String, PickleStep> pickleStepById = new ConcurrentHashMap<String, PickleStep>();
    private final Map<String, GherkingAstNodes> gherkinAstNodesById = new ConcurrentHashMap<String, GherkingAstNodes>();
    private TestRunStarted testRunStarted;
    private TestRunFinished testRunFinished;

    Query() {
    }

    public List<TestCaseStarted> findAllTestCaseStarted() {
        return new ArrayList<TestCaseStarted>(this.testCaseStarted);
    }

    public Optional<GherkingAstNodes> findGherkinAstNodesBy(Pickle pickle) {
        Objects.requireNonNull(pickle);
        List astNodeIds = pickle.getAstNodeIds();
        String pickleAstNodeId = (String)astNodeIds.get(astNodeIds.size() - 1);
        return Optional.ofNullable(this.gherkinAstNodesById.get(pickleAstNodeId));
    }

    public Optional<GherkingAstNodes> findGherkinAstNodesBy(TestCaseStarted testCaseStarted) {
        return this.findPickleBy(testCaseStarted).flatMap(this::findGherkinAstNodesBy);
    }

    public Optional<TestStepResult> findMostSevereTestStepResultStatusBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        return this.findTestStepsFinishedBy(testCaseStarted).stream().map(TestStepFinished::getTestStepResult).max(this.testStepResultComparator);
    }

    public Optional<Pickle> findPickleBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        return this.findTestCaseBy(testCaseStarted).map(TestCase::getPickleId).map(this.pickleById::get);
    }

    public Optional<PickleStep> findPickleStepBy(TestStep testStep) {
        Objects.requireNonNull(this.testCaseStarted);
        return testStep.getPickleStepId().map(this.pickleStepById::get);
    }

    public Optional<Step> findStepBy(PickleStep pickleStep) {
        Objects.requireNonNull(pickleStep);
        String stepId = (String)pickleStep.getAstNodeIds().get(0);
        return Optional.ofNullable(this.stepById.get(stepId));
    }

    public Optional<TestCase> findTestCaseBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        return Optional.ofNullable(this.testCaseById.get(testCaseStarted.getTestCaseId()));
    }

    public Optional<Duration> findTestCaseDurationBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        Timestamp started = testCaseStarted.getTimestamp();
        return this.findTestCaseFinishedBy(testCaseStarted).map(TestCaseFinished::getTimestamp).map(finished -> Duration.between(Convertor.toInstant((Timestamp)started), Convertor.toInstant((Timestamp)finished)));
    }

    public Optional<TestCaseFinished> findTestCaseFinishedBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        return Optional.ofNullable(this.testCaseFinishedByTestCaseStartedId.get(testCaseStarted.getId()));
    }

    public Optional<Duration> findTestRunDuration() {
        if (this.testRunStarted == null || this.testRunFinished == null) {
            return Optional.empty();
        }
        Duration between = Duration.between(Convertor.toInstant((Timestamp)this.testRunStarted.getTimestamp()), Convertor.toInstant((Timestamp)this.testRunFinished.getTimestamp()));
        return Optional.of(between);
    }

    public Optional<TestRunFinished> findTestRunFinished() {
        return Optional.ofNullable(this.testRunFinished);
    }

    public Optional<TestRunStarted> findTestRunStarted() {
        return Optional.ofNullable(this.testRunStarted);
    }

    public List<AbstractMap.SimpleEntry<TestStep, TestStepFinished>> findTestStepAndTestStepFinishedBy(TestCaseStarted testCaseStarted) {
        return this.findTestStepsFinishedBy(testCaseStarted).stream().map(testStepFinished -> this.findTestStepBy((TestStepFinished)testStepFinished).map(testStep -> new AbstractMap.SimpleEntry<TestStep, TestStepFinished>((TestStep)testStep, (TestStepFinished)testStepFinished))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Optional<TestStep> findTestStepBy(TestStepFinished testStepFinished) {
        Objects.requireNonNull(testStepFinished);
        return Optional.ofNullable(this.testStepById.get(testStepFinished.getTestStepId()));
    }

    public List<TestStepFinished> findTestStepsFinishedBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        List testStepsFinished = this.testStepsFinishedByTestCaseStartedId.getOrDefault(testCaseStarted.getId(), Collections.emptyList());
        return new ArrayList<TestStepFinished>(testStepsFinished);
    }

    public void update(Envelope envelope) {
        envelope.getTestRunStarted().ifPresent(this::updateTestRunStarted);
        envelope.getTestRunFinished().ifPresent(this::updateTestRunFinished);
        envelope.getTestCaseStarted().ifPresent(this::updateTestCaseStarted);
        envelope.getTestCaseFinished().ifPresent(this::updateTestCaseFinished);
        envelope.getTestStepFinished().ifPresent(this::updateTestStepFinished);
        envelope.getGherkinDocument().ifPresent(this::updateGherkinDocument);
        envelope.getPickle().ifPresent(this::updatePickle);
        envelope.getTestCase().ifPresent(this::updateTestCase);
    }

    private void updateTestCaseStarted(TestCaseStarted testCaseStarted) {
        this.testCaseStarted.add(testCaseStarted);
    }

    private void updateTestCase(TestCase event) {
        this.testCaseById.put(event.getId(), event);
        event.getTestSteps().forEach(testStep -> this.testStepById.put(testStep.getId(), (TestStep)testStep));
    }

    private void updatePickle(Pickle event) {
        this.pickleById.put(event.getId(), event);
        event.getSteps().forEach(pickleStep -> this.pickleStepById.put(pickleStep.getId(), (PickleStep)pickleStep));
    }

    private void updateGherkinDocument(GherkinDocument gherkinDocument) {
        gherkinDocument.getFeature().ifPresent(this::updateFeature);
    }

    private void updateFeature(Feature feature) {
        feature.getChildren().forEach(featureChild -> {
            featureChild.getBackground().ifPresent(background -> this.updateSteps(background.getSteps()));
            featureChild.getScenario().ifPresent(scenario -> this.updateScenario(feature, null, (Scenario)scenario));
            featureChild.getRule().ifPresent(rule -> rule.getChildren().forEach(ruleChild -> {
                ruleChild.getBackground().ifPresent(background -> this.updateSteps(background.getSteps()));
                ruleChild.getScenario().ifPresent(scenario -> this.updateScenario(feature, (Rule)rule, (Scenario)scenario));
            }));
        });
    }

    private void updateSteps(List<Step> steps) {
        steps.forEach(step -> this.stepById.put(step.getId(), (Step)step));
    }

    private void updateTestStepFinished(TestStepFinished event) {
        this.testStepsFinishedByTestCaseStartedId.compute(event.getTestCaseStartedId(), this.updateList(event));
    }

    private void updateTestCaseFinished(TestCaseFinished event) {
        this.testCaseFinishedByTestCaseStartedId.put(event.getTestCaseStartedId(), event);
    }

    private void updateTestRunFinished(TestRunFinished event) {
        this.testRunFinished = event;
    }

    private void updateTestRunStarted(TestRunStarted event) {
        this.testRunStarted = event;
    }

    private void updateScenario(Feature feature, Rule rule, Scenario scenario) {
        this.gherkinAstNodesById.put(scenario.getId(), new GherkingAstNodes(feature, rule, scenario));
        this.updateSteps(scenario.getSteps());
        List examples = scenario.getExamples();
        for (int examplesIndex = 0; examplesIndex < examples.size(); ++examplesIndex) {
            Examples currentExamples = (Examples)examples.get(examplesIndex);
            List tableRows = currentExamples.getTableBody();
            for (int exampleIndex = 0; exampleIndex < tableRows.size(); ++exampleIndex) {
                TableRow currentExample = (TableRow)tableRows.get(exampleIndex);
                this.gherkinAstNodesById.put(currentExample.getId(), new GherkingAstNodes(feature, rule, scenario, examplesIndex, currentExamples, exampleIndex, currentExample));
            }
        }
    }

    private <K, E> BiFunction<K, List<E>, List<E>> updateList(E element) {
        return (key, existing) -> {
            if (existing != null) {
                existing.add(element);
                return existing;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(element);
            return list;
        };
    }
}

