
package io.cucumber.messages.types;



/**
 * When removing a field, replace it with reserved, rather than deleting the line.
 *  When adding a field, add it to the end and increment the number by one.
 *  See https://developers.google.com/protocol-buffers/docs/proto#updating for details
 * 
 * *
 *  All the messages that are passed between different components/processes are Envelope
 *  messages.
 * 
 */
public class Envelope {

    /**
     * //// Attachments (parse errors, execution errors, screenshots, links...)
     * 
     * *
     *  An attachment represents any kind of data associated with a line in a
     *  [Source](#io.cucumber.messages.Source) file. It can be used for:
     * 
     *  * Syntax errors during parse time
     *  * Screenshots captured and attached during execution
     *  * Logs captured and attached during execution
     * 
     *  It is not to be used for runtime errors raised/thrown during execution. This
     *  is captured in `TestResult`.
     * 
     */
    private Attachment attachment;
    /**
     * *
     *  The [AST](https://en.wikipedia.org/wiki/Abstract_syntax_tree) of a Gherkin document.
     *  Cucumber implementations should *not* depend on `GherkinDocument` or any of its
     *  children for execution - use [Pickle](#io.cucumber.messages.Pickle) instead.
     * 
     *  The only consumers of `GherkinDocument` should only be formatters that produce
     *  "rich" output, resembling the original Gherkin document.
     * 
     */
    private GherkinDocument gherkinDocument;
    private Hook hook;
    /**
     * *
     *  This message contains meta information about the environment. Consumers can use
     *  this for various purposes.
     * 
     */
    private Meta meta;
    private ParameterType parameterType;
    private ParseError parseError;
    /**
     * //// Pickles
     * 
     * *
     *  A `Pickle` represents a template for a `TestCase`. It is typically derived
     *  from another format, such as [GherkinDocument](#io.cucumber.messages.GherkinDocument).
     *  In the future a `Pickle` may be derived from other formats such as Markdown or
     *  Excel files.
     * 
     *  By making `Pickle` the main data structure Cucumber uses for execution, the
     *  implementation of Cucumber itself becomes simpler, as it doesn't have to deal
     *  with the complex structure of a [GherkinDocument](#io.cucumber.messages.GherkinDocument).
     * 
     *  Each `PickleStep` of a `Pickle` is matched with a `StepDefinition` to create a `TestCase`
     * 
     */
    private Pickle pickle;
    /**
     * //// Source
     * 
     * *
     *  A source file, typically a Gherkin document or Java/Ruby/JavaScript source code
     * 
     */
    private Source source;
    private StepDefinition stepDefinition;
    /**
     * //// TestCases
     * 
     * *
     *  A `TestCase` contains a sequence of `TestStep`s.
     * 
     */
    private TestCase testCase;
    private TestCaseFinished testCaseFinished;
    private TestCaseStarted testCaseStarted;
    private TestRunFinished testRunFinished;
    private TestRunStarted testRunStarted;
    private TestStepFinished testStepFinished;
    private TestStepStarted testStepStarted;
    private UndefinedParameterType undefinedParameterType;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Envelope() {
    }

    /**
     * 
     * @param parameterType
     * @param undefinedParameterType
     * @param parseError
     * @param source
     * @param pickle
     * @param testStepFinished
     * @param testCaseStarted
     * @param hook
     * @param attachment
     * @param testCaseFinished
     * @param meta
     * @param testRunStarted
     * @param gherkinDocument
     * @param stepDefinition
     * @param testCase
     * @param testRunFinished
     * @param testStepStarted
     */
    public Envelope(Attachment attachment, GherkinDocument gherkinDocument, Hook hook, Meta meta, ParameterType parameterType, ParseError parseError, Pickle pickle, Source source, StepDefinition stepDefinition, TestCase testCase, TestCaseFinished testCaseFinished, TestCaseStarted testCaseStarted, TestRunFinished testRunFinished, TestRunStarted testRunStarted, TestStepFinished testStepFinished, TestStepStarted testStepStarted, UndefinedParameterType undefinedParameterType) {
        super();
        this.attachment = attachment;
        this.gherkinDocument = gherkinDocument;
        this.hook = hook;
        this.meta = meta;
        this.parameterType = parameterType;
        this.parseError = parseError;
        this.pickle = pickle;
        this.source = source;
        this.stepDefinition = stepDefinition;
        this.testCase = testCase;
        this.testCaseFinished = testCaseFinished;
        this.testCaseStarted = testCaseStarted;
        this.testRunFinished = testRunFinished;
        this.testRunStarted = testRunStarted;
        this.testStepFinished = testStepFinished;
        this.testStepStarted = testStepStarted;
        this.undefinedParameterType = undefinedParameterType;
    }

    /**
     * //// Attachments (parse errors, execution errors, screenshots, links...)
     * 
     * *
     *  An attachment represents any kind of data associated with a line in a
     *  [Source](#io.cucumber.messages.Source) file. It can be used for:
     * 
     *  * Syntax errors during parse time
     *  * Screenshots captured and attached during execution
     *  * Logs captured and attached during execution
     * 
     *  It is not to be used for runtime errors raised/thrown during execution. This
     *  is captured in `TestResult`.
     * 
     */
    public Attachment getAttachment() {
        return attachment;
    }

    /**
     * //// Attachments (parse errors, execution errors, screenshots, links...)
     * 
     * *
     *  An attachment represents any kind of data associated with a line in a
     *  [Source](#io.cucumber.messages.Source) file. It can be used for:
     * 
     *  * Syntax errors during parse time
     *  * Screenshots captured and attached during execution
     *  * Logs captured and attached during execution
     * 
     *  It is not to be used for runtime errors raised/thrown during execution. This
     *  is captured in `TestResult`.
     * 
     */
    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    /**
     * *
     *  The [AST](https://en.wikipedia.org/wiki/Abstract_syntax_tree) of a Gherkin document.
     *  Cucumber implementations should *not* depend on `GherkinDocument` or any of its
     *  children for execution - use [Pickle](#io.cucumber.messages.Pickle) instead.
     * 
     *  The only consumers of `GherkinDocument` should only be formatters that produce
     *  "rich" output, resembling the original Gherkin document.
     * 
     */
    public GherkinDocument getGherkinDocument() {
        return gherkinDocument;
    }

    /**
     * *
     *  The [AST](https://en.wikipedia.org/wiki/Abstract_syntax_tree) of a Gherkin document.
     *  Cucumber implementations should *not* depend on `GherkinDocument` or any of its
     *  children for execution - use [Pickle](#io.cucumber.messages.Pickle) instead.
     * 
     *  The only consumers of `GherkinDocument` should only be formatters that produce
     *  "rich" output, resembling the original Gherkin document.
     * 
     */
    public void setGherkinDocument(GherkinDocument gherkinDocument) {
        this.gherkinDocument = gherkinDocument;
    }

    public Hook getHook() {
        return hook;
    }

    public void setHook(Hook hook) {
        this.hook = hook;
    }

    /**
     * *
     *  This message contains meta information about the environment. Consumers can use
     *  this for various purposes.
     * 
     */
    public Meta getMeta() {
        return meta;
    }

    /**
     * *
     *  This message contains meta information about the environment. Consumers can use
     *  this for various purposes.
     * 
     */
    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public ParameterType getParameterType() {
        return parameterType;
    }

    public void setParameterType(ParameterType parameterType) {
        this.parameterType = parameterType;
    }

    public ParseError getParseError() {
        return parseError;
    }

    public void setParseError(ParseError parseError) {
        this.parseError = parseError;
    }

    /**
     * //// Pickles
     * 
     * *
     *  A `Pickle` represents a template for a `TestCase`. It is typically derived
     *  from another format, such as [GherkinDocument](#io.cucumber.messages.GherkinDocument).
     *  In the future a `Pickle` may be derived from other formats such as Markdown or
     *  Excel files.
     * 
     *  By making `Pickle` the main data structure Cucumber uses for execution, the
     *  implementation of Cucumber itself becomes simpler, as it doesn't have to deal
     *  with the complex structure of a [GherkinDocument](#io.cucumber.messages.GherkinDocument).
     * 
     *  Each `PickleStep` of a `Pickle` is matched with a `StepDefinition` to create a `TestCase`
     * 
     */
    public Pickle getPickle() {
        return pickle;
    }

    /**
     * //// Pickles
     * 
     * *
     *  A `Pickle` represents a template for a `TestCase`. It is typically derived
     *  from another format, such as [GherkinDocument](#io.cucumber.messages.GherkinDocument).
     *  In the future a `Pickle` may be derived from other formats such as Markdown or
     *  Excel files.
     * 
     *  By making `Pickle` the main data structure Cucumber uses for execution, the
     *  implementation of Cucumber itself becomes simpler, as it doesn't have to deal
     *  with the complex structure of a [GherkinDocument](#io.cucumber.messages.GherkinDocument).
     * 
     *  Each `PickleStep` of a `Pickle` is matched with a `StepDefinition` to create a `TestCase`
     * 
     */
    public void setPickle(Pickle pickle) {
        this.pickle = pickle;
    }

    /**
     * //// Source
     * 
     * *
     *  A source file, typically a Gherkin document or Java/Ruby/JavaScript source code
     * 
     */
    public Source getSource() {
        return source;
    }

    /**
     * //// Source
     * 
     * *
     *  A source file, typically a Gherkin document or Java/Ruby/JavaScript source code
     * 
     */
    public void setSource(Source source) {
        this.source = source;
    }

    public StepDefinition getStepDefinition() {
        return stepDefinition;
    }

    public void setStepDefinition(StepDefinition stepDefinition) {
        this.stepDefinition = stepDefinition;
    }

    /**
     * //// TestCases
     * 
     * *
     *  A `TestCase` contains a sequence of `TestStep`s.
     * 
     */
    public TestCase getTestCase() {
        return testCase;
    }

    /**
     * //// TestCases
     * 
     * *
     *  A `TestCase` contains a sequence of `TestStep`s.
     * 
     */
    public void setTestCase(TestCase testCase) {
        this.testCase = testCase;
    }

    public TestCaseFinished getTestCaseFinished() {
        return testCaseFinished;
    }

    public void setTestCaseFinished(TestCaseFinished testCaseFinished) {
        this.testCaseFinished = testCaseFinished;
    }

    public TestCaseStarted getTestCaseStarted() {
        return testCaseStarted;
    }

    public void setTestCaseStarted(TestCaseStarted testCaseStarted) {
        this.testCaseStarted = testCaseStarted;
    }

    public TestRunFinished getTestRunFinished() {
        return testRunFinished;
    }

    public void setTestRunFinished(TestRunFinished testRunFinished) {
        this.testRunFinished = testRunFinished;
    }

    public TestRunStarted getTestRunStarted() {
        return testRunStarted;
    }

    public void setTestRunStarted(TestRunStarted testRunStarted) {
        this.testRunStarted = testRunStarted;
    }

    public TestStepFinished getTestStepFinished() {
        return testStepFinished;
    }

    public void setTestStepFinished(TestStepFinished testStepFinished) {
        this.testStepFinished = testStepFinished;
    }

    public TestStepStarted getTestStepStarted() {
        return testStepStarted;
    }

    public void setTestStepStarted(TestStepStarted testStepStarted) {
        this.testStepStarted = testStepStarted;
    }

    public UndefinedParameterType getUndefinedParameterType() {
        return undefinedParameterType;
    }

    public void setUndefinedParameterType(UndefinedParameterType undefinedParameterType) {
        this.undefinedParameterType = undefinedParameterType;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Envelope.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attachment");
        sb.append('=');
        sb.append(((this.attachment == null)?"<null>":this.attachment));
        sb.append(',');
        sb.append("gherkinDocument");
        sb.append('=');
        sb.append(((this.gherkinDocument == null)?"<null>":this.gherkinDocument));
        sb.append(',');
        sb.append("hook");
        sb.append('=');
        sb.append(((this.hook == null)?"<null>":this.hook));
        sb.append(',');
        sb.append("meta");
        sb.append('=');
        sb.append(((this.meta == null)?"<null>":this.meta));
        sb.append(',');
        sb.append("parameterType");
        sb.append('=');
        sb.append(((this.parameterType == null)?"<null>":this.parameterType));
        sb.append(',');
        sb.append("parseError");
        sb.append('=');
        sb.append(((this.parseError == null)?"<null>":this.parseError));
        sb.append(',');
        sb.append("pickle");
        sb.append('=');
        sb.append(((this.pickle == null)?"<null>":this.pickle));
        sb.append(',');
        sb.append("source");
        sb.append('=');
        sb.append(((this.source == null)?"<null>":this.source));
        sb.append(',');
        sb.append("stepDefinition");
        sb.append('=');
        sb.append(((this.stepDefinition == null)?"<null>":this.stepDefinition));
        sb.append(',');
        sb.append("testCase");
        sb.append('=');
        sb.append(((this.testCase == null)?"<null>":this.testCase));
        sb.append(',');
        sb.append("testCaseFinished");
        sb.append('=');
        sb.append(((this.testCaseFinished == null)?"<null>":this.testCaseFinished));
        sb.append(',');
        sb.append("testCaseStarted");
        sb.append('=');
        sb.append(((this.testCaseStarted == null)?"<null>":this.testCaseStarted));
        sb.append(',');
        sb.append("testRunFinished");
        sb.append('=');
        sb.append(((this.testRunFinished == null)?"<null>":this.testRunFinished));
        sb.append(',');
        sb.append("testRunStarted");
        sb.append('=');
        sb.append(((this.testRunStarted == null)?"<null>":this.testRunStarted));
        sb.append(',');
        sb.append("testStepFinished");
        sb.append('=');
        sb.append(((this.testStepFinished == null)?"<null>":this.testStepFinished));
        sb.append(',');
        sb.append("testStepStarted");
        sb.append('=');
        sb.append(((this.testStepStarted == null)?"<null>":this.testStepStarted));
        sb.append(',');
        sb.append("undefinedParameterType");
        sb.append('=');
        sb.append(((this.undefinedParameterType == null)?"<null>":this.undefinedParameterType));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.parameterType == null)? 0 :this.parameterType.hashCode()));
        result = ((result* 31)+((this.undefinedParameterType == null)? 0 :this.undefinedParameterType.hashCode()));
        result = ((result* 31)+((this.parseError == null)? 0 :this.parseError.hashCode()));
        result = ((result* 31)+((this.source == null)? 0 :this.source.hashCode()));
        result = ((result* 31)+((this.pickle == null)? 0 :this.pickle.hashCode()));
        result = ((result* 31)+((this.testStepFinished == null)? 0 :this.testStepFinished.hashCode()));
        result = ((result* 31)+((this.testCaseStarted == null)? 0 :this.testCaseStarted.hashCode()));
        result = ((result* 31)+((this.hook == null)? 0 :this.hook.hashCode()));
        result = ((result* 31)+((this.attachment == null)? 0 :this.attachment.hashCode()));
        result = ((result* 31)+((this.testCaseFinished == null)? 0 :this.testCaseFinished.hashCode()));
        result = ((result* 31)+((this.meta == null)? 0 :this.meta.hashCode()));
        result = ((result* 31)+((this.testRunStarted == null)? 0 :this.testRunStarted.hashCode()));
        result = ((result* 31)+((this.gherkinDocument == null)? 0 :this.gherkinDocument.hashCode()));
        result = ((result* 31)+((this.stepDefinition == null)? 0 :this.stepDefinition.hashCode()));
        result = ((result* 31)+((this.testCase == null)? 0 :this.testCase.hashCode()));
        result = ((result* 31)+((this.testRunFinished == null)? 0 :this.testRunFinished.hashCode()));
        result = ((result* 31)+((this.testStepStarted == null)? 0 :this.testStepStarted.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Envelope) == false) {
            return false;
        }
        Envelope rhs = ((Envelope) other);
        return ((((((((((((((((((this.parameterType == rhs.parameterType)||((this.parameterType!= null)&&this.parameterType.equals(rhs.parameterType)))&&((this.undefinedParameterType == rhs.undefinedParameterType)||((this.undefinedParameterType!= null)&&this.undefinedParameterType.equals(rhs.undefinedParameterType))))&&((this.parseError == rhs.parseError)||((this.parseError!= null)&&this.parseError.equals(rhs.parseError))))&&((this.source == rhs.source)||((this.source!= null)&&this.source.equals(rhs.source))))&&((this.pickle == rhs.pickle)||((this.pickle!= null)&&this.pickle.equals(rhs.pickle))))&&((this.testStepFinished == rhs.testStepFinished)||((this.testStepFinished!= null)&&this.testStepFinished.equals(rhs.testStepFinished))))&&((this.testCaseStarted == rhs.testCaseStarted)||((this.testCaseStarted!= null)&&this.testCaseStarted.equals(rhs.testCaseStarted))))&&((this.hook == rhs.hook)||((this.hook!= null)&&this.hook.equals(rhs.hook))))&&((this.attachment == rhs.attachment)||((this.attachment!= null)&&this.attachment.equals(rhs.attachment))))&&((this.testCaseFinished == rhs.testCaseFinished)||((this.testCaseFinished!= null)&&this.testCaseFinished.equals(rhs.testCaseFinished))))&&((this.meta == rhs.meta)||((this.meta!= null)&&this.meta.equals(rhs.meta))))&&((this.testRunStarted == rhs.testRunStarted)||((this.testRunStarted!= null)&&this.testRunStarted.equals(rhs.testRunStarted))))&&((this.gherkinDocument == rhs.gherkinDocument)||((this.gherkinDocument!= null)&&this.gherkinDocument.equals(rhs.gherkinDocument))))&&((this.stepDefinition == rhs.stepDefinition)||((this.stepDefinition!= null)&&this.stepDefinition.equals(rhs.stepDefinition))))&&((this.testCase == rhs.testCase)||((this.testCase!= null)&&this.testCase.equals(rhs.testCase))))&&((this.testRunFinished == rhs.testRunFinished)||((this.testRunFinished!= null)&&this.testRunFinished.equals(rhs.testRunFinished))))&&((this.testStepStarted == rhs.testStepStarted)||((this.testStepStarted!= null)&&this.testStepStarted.equals(rhs.testStepStarted))));
    }

}
