
package io.cucumber.messages.types;


public class Hook {

    /**
     * 
     * (Required)
     * 
     */
    private String id;
    /**
     * *
     *  Points to a [Source](#io.cucumber.messages.Source) identified by `uri` and a
     *  [Location](#io.cucumber.messages.Location) within that file.
     * (Required)
     * 
     */
    private SourceReference sourceReference;
    private String tagExpression;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Hook() {
    }

    /**
     * 
     * @param sourceReference
     * @param id
     * @param tagExpression
     */
    public Hook(String id, SourceReference sourceReference, String tagExpression) {
        super();
        this.id = id;
        this.sourceReference = sourceReference;
        this.tagExpression = tagExpression;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getId() {
        return id;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * *
     *  Points to a [Source](#io.cucumber.messages.Source) identified by `uri` and a
     *  [Location](#io.cucumber.messages.Location) within that file.
     * (Required)
     * 
     */
    public SourceReference getSourceReference() {
        return sourceReference;
    }

    /**
     * *
     *  Points to a [Source](#io.cucumber.messages.Source) identified by `uri` and a
     *  [Location](#io.cucumber.messages.Location) within that file.
     * (Required)
     * 
     */
    public void setSourceReference(SourceReference sourceReference) {
        this.sourceReference = sourceReference;
    }

    public String getTagExpression() {
        return tagExpression;
    }

    public void setTagExpression(String tagExpression) {
        this.tagExpression = tagExpression;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Hook.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("sourceReference");
        sb.append('=');
        sb.append(((this.sourceReference == null)?"<null>":this.sourceReference));
        sb.append(',');
        sb.append("tagExpression");
        sb.append('=');
        sb.append(((this.tagExpression == null)?"<null>":this.tagExpression));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.sourceReference == null)? 0 :this.sourceReference.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.tagExpression == null)? 0 :this.tagExpression.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Hook) == false) {
            return false;
        }
        Hook rhs = ((Hook) other);
        return ((((this.sourceReference == rhs.sourceReference)||((this.sourceReference!= null)&&this.sourceReference.equals(rhs.sourceReference)))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.tagExpression == rhs.tagExpression)||((this.tagExpression!= null)&&this.tagExpression.equals(rhs.tagExpression))));
    }

}
