
package io.cucumber.messages.types;

import java.util.ArrayList;
import java.util.List;

public class PickleTable {

    /**
     * 
     * (Required)
     * 
     */
    private List<PickleTableRow> rows = new ArrayList<PickleTableRow>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public PickleTable() {
    }

    /**
     * 
     * @param rows
     */
    public PickleTable(List<PickleTableRow> rows) {
        super();
        this.rows = rows;
    }

    /**
     * 
     * (Required)
     * 
     */
    public List<PickleTableRow> getRows() {
        return rows;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setRows(List<PickleTableRow> rows) {
        this.rows = rows;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PickleTable.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("rows");
        sb.append('=');
        sb.append(((this.rows == null)?"<null>":this.rows));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.rows == null)? 0 :this.rows.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof PickleTable) == false) {
            return false;
        }
        PickleTable rhs = ((PickleTable) other);
        return ((this.rows == rhs.rows)||((this.rows!= null)&&this.rows.equals(rhs.rows)));
    }

}
