
package io.cucumber.messages.types;



/**
 * Used to describe various properties of Meta
 * 
 */
public class Product {

    /**
     * The product name
     * (Required)
     * 
     */
    private String name;
    /**
     * The product version
     * 
     */
    private String version;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Product() {
    }

    /**
     * 
     * @param name
     * @param version
     */
    public Product(String name, String version) {
        super();
        this.name = name;
        this.version = version;
    }

    /**
     * The product name
     * (Required)
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * The product name
     * (Required)
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * The product version
     * 
     */
    public String getVersion() {
        return version;
    }

    /**
     * The product version
     * 
     */
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Product.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(((this.version == null)?"<null>":this.version));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.version == null)? 0 :this.version.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Product) == false) {
            return false;
        }
        Product rhs = ((Product) other);
        return (((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name)))&&((this.version == rhs.version)||((this.version!= null)&&this.version.equals(rhs.version))));
    }

}
