
package io.cucumber.messages.types;


public class TestCaseFinished {

    /**
     * 
     * (Required)
     * 
     */
    private String testCaseStartedId;
    /**
     * 
     * (Required)
     * 
     */
    private Timestamp timestamp;
    /**
     * 
     * (Required)
     * 
     */
    private Boolean willBeRetried;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TestCaseFinished() {
    }

    /**
     * 
     * @param willBeRetried
     * @param testCaseStartedId
     * @param timestamp
     */
    public TestCaseFinished(String testCaseStartedId, Timestamp timestamp, Boolean willBeRetried) {
        super();
        this.testCaseStartedId = testCaseStartedId;
        this.timestamp = timestamp;
        this.willBeRetried = willBeRetried;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getTestCaseStartedId() {
        return testCaseStartedId;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setTestCaseStartedId(String testCaseStartedId) {
        this.testCaseStartedId = testCaseStartedId;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Timestamp getTimestamp() {
        return timestamp;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Boolean getWillBeRetried() {
        return willBeRetried;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setWillBeRetried(Boolean willBeRetried) {
        this.willBeRetried = willBeRetried;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TestCaseFinished.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("testCaseStartedId");
        sb.append('=');
        sb.append(((this.testCaseStartedId == null)?"<null>":this.testCaseStartedId));
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(((this.timestamp == null)?"<null>":this.timestamp));
        sb.append(',');
        sb.append("willBeRetried");
        sb.append('=');
        sb.append(((this.willBeRetried == null)?"<null>":this.willBeRetried));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.willBeRetried == null)? 0 :this.willBeRetried.hashCode()));
        result = ((result* 31)+((this.testCaseStartedId == null)? 0 :this.testCaseStartedId.hashCode()));
        result = ((result* 31)+((this.timestamp == null)? 0 :this.timestamp.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TestCaseFinished) == false) {
            return false;
        }
        TestCaseFinished rhs = ((TestCaseFinished) other);
        return ((((this.willBeRetried == rhs.willBeRetried)||((this.willBeRetried!= null)&&this.willBeRetried.equals(rhs.willBeRetried)))&&((this.testCaseStartedId == rhs.testCaseStartedId)||((this.testCaseStartedId!= null)&&this.testCaseStartedId.equals(rhs.testCaseStartedId))))&&((this.timestamp == rhs.timestamp)||((this.timestamp!= null)&&this.timestamp.equals(rhs.timestamp))));
    }

}
