/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.prettyformatter;

import io.cucumber.messages.types.Envelope;
import io.cucumber.prettyformatter.PrettyReportData;
import io.cucumber.prettyformatter.PrettyReportWriter;
import io.cucumber.prettyformatter.Theme;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public final class MessagesToPrettyWriter
implements AutoCloseable {
    private final PrettyReportData data;
    private final PrettyReportWriter writer;
    private boolean streamClosed = false;

    private MessagesToPrettyWriter(OutputStream out, Theme theme, Function<String, String> uriFormatter, Set<PrettyFeature> features) {
        this.data = new PrettyReportData(features);
        this.writer = new PrettyReportWriter(out, theme, uriFormatter, features, this.data);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void write(Envelope envelope) throws IOException {
        if (this.streamClosed) {
            throw new IOException("Stream closed");
        }
        this.data.collect(envelope);
        envelope.getTestCaseStarted().ifPresent(this.writer::handleTestCaseStarted);
        envelope.getTestStepFinished().ifPresent(this.writer::handleTestStepFinished);
        envelope.getTestRunFinished().ifPresent(this.writer::handleTestRunFinished);
        envelope.getAttachment().ifPresent(this.writer::handleAttachment);
    }

    @Override
    public void close() {
        if (this.streamClosed) {
            return;
        }
        try {
            this.writer.close();
        }
        finally {
            this.streamClosed = true;
        }
    }

    public static final class Builder {
        private final Set<PrettyFeature> features = EnumSet.of(PrettyFeature.INCLUDE_FEATURE_LINE, PrettyFeature.INCLUDE_RULE_LINE);
        private Theme theme = Theme.none();
        private Function<String, String> uriFormatter = Function.identity();

        private Builder() {
        }

        private static Function<String, String> removePrefix(String prefix) {
            return s -> {
                if (s.startsWith(prefix)) {
                    return s.substring(prefix.length());
                }
                return s;
            };
        }

        public Builder theme(Theme theme) {
            this.theme = Objects.requireNonNull(theme);
            return this;
        }

        public Builder removeUriPrefix(String prefix) {
            this.uriFormatter = Builder.removePrefix(Objects.requireNonNull(prefix));
            return this;
        }

        public Builder feature(PrettyFeature feature, boolean enabled) {
            if (enabled) {
                this.features.add(feature);
            } else {
                this.features.remove((Object)feature);
            }
            return this;
        }

        public MessagesToPrettyWriter build(OutputStream out) {
            Objects.requireNonNull(out);
            return new MessagesToPrettyWriter(out, this.theme, this.uriFormatter, this.features);
        }
    }

    public static enum PrettyFeature {
        INCLUDE_FEATURE_LINE,
        INCLUDE_RULE_LINE;

    }
}

