/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.prettyformatter;

import io.cucumber.messages.types.Attachment;
import io.cucumber.messages.types.Exception;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Group;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleDocString;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.PickleTable;
import io.cucumber.messages.types.PickleTag;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.StepMatchArgument;
import io.cucumber.messages.types.TestCaseStarted;
import io.cucumber.messages.types.TestRunFinished;
import io.cucumber.messages.types.TestStep;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.messages.types.TestStepResultStatus;
import io.cucumber.prettyformatter.LineBuilder;
import io.cucumber.prettyformatter.MessagesToPrettyWriter;
import io.cucumber.prettyformatter.PickleDocStringFormatter;
import io.cucumber.prettyformatter.PickleTableFormatter;
import io.cucumber.prettyformatter.PrettyReportData;
import io.cucumber.prettyformatter.SourceReferenceFormatter;
import io.cucumber.prettyformatter.Theme;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

class PrettyReportWriter
implements AutoCloseable {
    private final Theme theme;
    private final SourceReferenceFormatter sourceReferenceFormatter;
    private final Function<String, String> uriFormatter;
    private final PrintWriter writer;
    private final Set<MessagesToPrettyWriter.PrettyFeature> features;
    private final PrettyReportData data;

    PrettyReportWriter(OutputStream out, Theme theme, Function<String, String> uriFormatter, Set<MessagesToPrettyWriter.PrettyFeature> features, PrettyReportData data) {
        this.theme = Objects.requireNonNull(theme);
        this.writer = PrettyReportWriter.createPrintWriter(Objects.requireNonNull(out));
        this.uriFormatter = Objects.requireNonNull(uriFormatter);
        this.features = features;
        this.data = data;
        this.sourceReferenceFormatter = new SourceReferenceFormatter(uriFormatter);
    }

    private static PrintWriter createPrintWriter(OutputStream out) {
        return new PrintWriter(new OutputStreamWriter(Objects.requireNonNull(out), StandardCharsets.UTF_8));
    }

    void handleTestCaseStarted(TestCaseStarted event) {
        this.data.findLineageBy(event).ifPresent(lineage -> {
            if (this.features.contains((Object)MessagesToPrettyWriter.PrettyFeature.INCLUDE_FEATURE_LINE)) {
                lineage.feature().ifPresent(this::printFeature);
            }
            if (this.features.contains((Object)MessagesToPrettyWriter.PrettyFeature.INCLUDE_RULE_LINE)) {
                lineage.rule().ifPresent(this::printRule);
            }
        });
        this.writer.println();
        this.printTags(event);
        this.printScenarioDefinition(event);
        this.writer.flush();
    }

    private void printFeature(Feature feature) {
        this.data.ifNotSeenBefore(feature, () -> {
            this.writer.println();
            this.writer.println(new LineBuilder(this.theme).begin(Theme.Element.FEATURE).title(Theme.Element.FEATURE_KEYWORD, feature.getKeyword(), Theme.Element.FEATURE_NAME, feature.getName()).end(Theme.Element.FEATURE).build());
        });
    }

    private void printRule(Rule rule) {
        this.data.ifNotSeenBefore(rule, () -> this.writer.println(new LineBuilder(this.theme).newLine().indent(this.data.getAfterFeatureIndent()).begin(Theme.Element.RULE).title(Theme.Element.RULE_KEYWORD, rule.getKeyword(), Theme.Element.RULE_NAME, rule.getName()).end(Theme.Element.RULE).build()));
    }

    private void printTags(TestCaseStarted event) {
        this.data.findTagsBy(event).map(pickleTags -> new LineBuilder(this.theme).indent(this.data.getScenarioIndentBy(event)).append(Theme.Element.TAG, this.formatTagLine((List<PickleTag>)pickleTags)).build()).ifPresent(this.writer::println);
    }

    private String formatTagLine(List<PickleTag> pickleTags) {
        return pickleTags.stream().map(PickleTag::getName).collect(Collectors.joining(" "));
    }

    private void printScenarioDefinition(TestCaseStarted event) {
        this.data.findPickleBy(event).ifPresent(pickle -> this.data.findScenarioBy((Pickle)pickle).ifPresent(scenario -> this.writer.println(this.formatScenarioLine(event, (Pickle)pickle, (Scenario)scenario))));
    }

    private String formatScenarioLine(TestCaseStarted event, Pickle pickle, Scenario scenario) {
        return new LineBuilder(this.theme).indent(this.data.getScenarioIndentBy(event)).title(Theme.Element.SCENARIO_KEYWORD, scenario.getKeyword(), Theme.Element.SCENARIO_NAME, pickle.getName()).addPaddingUpTo(this.data.getCommentStartAtIndexBy(event)).append(Theme.Element.LOCATION, "# " + this.formatLocation(pickle)).build();
    }

    private String formatLocation(Pickle pickle) {
        String path = this.uriFormatter.apply(pickle.getUri());
        return this.data.findLineOf(pickle).map(line -> path + ":" + line).orElse(path);
    }

    void handleTestStepFinished(TestStepFinished event) {
        this.printStep(event);
        this.printException(event);
        this.writer.flush();
    }

    private void printStep(TestStepFinished event) {
        this.data.findTestStepBy(event).ifPresent(testStep -> this.data.findPickleStepBy((TestStep)testStep).ifPresent(pickleStep -> this.data.findStepBy((PickleStep)pickleStep).ifPresent(step -> {
            this.writer.println(this.formatStep(event, (TestStep)testStep, (PickleStep)pickleStep, (Step)step));
            pickleStep.getArgument().ifPresent(pickleStepArgument -> {
                pickleStepArgument.getDataTable().ifPresent(pickleTable -> this.writer.print(new LineBuilder(this.theme).accept(lineBuilder -> PickleTableFormatter.builder().indentation(this.data.getArgumentIndentBy(event)).build().formatTo((PickleTable)pickleTable, (LineBuilder)lineBuilder)).build()));
                pickleStepArgument.getDocString().ifPresent(pickleDocString -> this.writer.print(new LineBuilder(this.theme).accept(lineBuilder -> PickleDocStringFormatter.builder().indentation(this.data.getArgumentIndentBy(event)).build().formatTo((PickleDocString)pickleDocString, (LineBuilder)lineBuilder)).build()));
            });
        })));
    }

    private String formatStep(TestStepFinished event, TestStep testStep, PickleStep pickleStep, Step step) {
        TestStepResultStatus status = event.getTestStepResult().getStatus();
        return new LineBuilder(this.theme).indent(this.data.getStepIndentBy(event)).begin(Theme.Element.STEP, status).append(Theme.Element.STEP_KEYWORD, step.getKeyword()).accept(lineBuilder -> this.formatStepText((LineBuilder)lineBuilder, testStep, pickleStep)).end(Theme.Element.STEP, status).accept(lineBuilder -> this.formatLocation(testStep).ifPresent(location -> lineBuilder.addPaddingUpTo(this.data.getCommentStartAtIndexBy(event)).append(Theme.Element.LOCATION, "# " + location))).build();
    }

    private void formatStepText(LineBuilder line, TestStep testStep, PickleStep pickleStep) {
        this.formatStepText(line, pickleStep.getText(), this.getStepMatchArguments(testStep));
    }

    private List<StepMatchArgument> getStepMatchArguments(TestStep testStep) {
        ArrayList<StepMatchArgument> stepMatchArguments = new ArrayList<StepMatchArgument>();
        testStep.getStepMatchArgumentsLists().orElse(Collections.emptyList()).forEach(list -> stepMatchArguments.addAll(list.getStepMatchArguments()));
        return stepMatchArguments;
    }

    void formatStepText(LineBuilder lineBuilder, String stepText, List<StepMatchArgument> arguments) {
        int beginIndex = 0;
        for (StepMatchArgument argument : arguments) {
            int argumentEndIndex;
            Group group = argument.getGroup();
            Optional value = group.getValue();
            if (!value.isPresent()) continue;
            int argumentOffset = (int)group.getStart().orElse(-1L).longValue();
            String text = stepText.substring(beginIndex, argumentOffset);
            beginIndex = argumentEndIndex = argumentOffset + ((String)value.get()).length();
            lineBuilder.append(Theme.Element.STEP_TEXT, text).append(Theme.Element.STEP_ARGUMENT, stepText.substring(argumentOffset, argumentEndIndex));
        }
        if (beginIndex != stepText.length()) {
            lineBuilder.append(Theme.Element.STEP_TEXT, stepText.substring(beginIndex));
        }
    }

    private Optional<String> formatLocation(TestStep testStep) {
        return this.data.findSourceReferenceBy(testStep).flatMap(this.sourceReferenceFormatter::format);
    }

    private void printException(TestStepFinished event) {
        TestStepResultStatus status = event.getTestStepResult().getStatus();
        event.getTestStepResult().getException().ifPresent(exception -> this.writer.println(this.formatError(this.data.getStackTraceIndentBy(event), (Exception)exception, status)));
    }

    void handleAttachment(Attachment attachment) {
        this.writer.println();
        switch (attachment.getContentEncoding()) {
            case BASE64: {
                this.writer.println(this.formatBase64Attachment(attachment));
                break;
            }
            case IDENTITY: {
                this.writer.print(this.formatTextAttachment(attachment));
            }
        }
        this.writer.println();
        this.writer.flush();
    }

    private String formatBase64Attachment(Attachment event) {
        int bytes = event.getBody().length() / 4 * 3;
        String line = event.getFileName().isPresent() ? String.format("Embedding %s [%s %d bytes]", event.getFileName().get(), event.getMediaType(), bytes) : String.format("Embedding [%s %d bytes]", event.getMediaType(), bytes);
        return new LineBuilder(this.theme).indent(this.data.getAttachmentIndentBy(event)).append(Theme.Element.ATTACHMENT, line).build();
    }

    private String formatTextAttachment(Attachment event) {
        int indent = this.data.getAttachmentIndentBy(event);
        LineBuilder builder = new LineBuilder(this.theme);
        try (BufferedReader lines = new BufferedReader(new StringReader(event.getBody()));){
            String line;
            while ((line = lines.readLine()) != null) {
                builder.indent(indent).append(Theme.Element.ATTACHMENT, line).newLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return builder.build();
    }

    void handleTestRunFinished(TestRunFinished event) {
        this.printException(event);
        this.writer.close();
    }

    private void printException(TestRunFinished event) {
        event.getException().ifPresent(exception -> this.writer.println(this.formatError(0, (Exception)exception, TestStepResultStatus.FAILED)));
    }

    private String formatError(int indent, Exception exception, TestStepResultStatus status) {
        if (exception.getStackTrace().isPresent()) {
            String stacktrace = (String)exception.getStackTrace().get();
            return this.formatError(indent, stacktrace, status);
        }
        if (exception.getMessage().isPresent()) {
            String message = (String)exception.getMessage().get();
            return this.formatError(indent, message, status);
        }
        return "";
    }

    private String formatError(int indent, String message, TestStepResultStatus status) {
        LineBuilder lineBuilder = new LineBuilder(this.theme);
        try (BufferedReader lines = new BufferedReader(new StringReader(message));){
            String line;
            boolean first = true;
            while ((line = lines.readLine()) != null) {
                if (!first) {
                    lineBuilder.newLine();
                }
                lineBuilder.indent(indent);
                if (first) {
                    lineBuilder.begin(Theme.Element.STEP, status);
                    first = false;
                }
                lineBuilder.append(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return lineBuilder.end(Theme.Element.STEP, status).newLine().build();
    }

    @Override
    public void close() {
        this.writer.close();
    }
}

