/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.prettyformatter;

import io.cucumber.messages.types.Attachment;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.PickleTag;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.SourceReference;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.StepDefinition;
import io.cucumber.messages.types.TestCaseStarted;
import io.cucumber.messages.types.TestStep;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.prettyformatter.MessagesToPrettyWriter;
import io.cucumber.query.Lineage;
import io.cucumber.query.Query;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

final class PrettyReportData {
    static final int VISUAL_STATUS_ICON_LENGTH = 1;
    private static final int AFTER_SCENARIO_ATTACHMENT_INDENT = 6;
    private static final int AFTER_STEP_STACKTRACE_INDENT = 4;
    private static final int AFTER_STEP_ARGUMENT_INDENT = 2;
    private static final int STEP_INDENT = 2;
    private static final int ONE_SPACE_LENGTH = 1;
    private final Query query = new Query();
    private final Map<String, Integer> commentStartIndexByTestCaseStartedId = new HashMap<String, Integer>();
    private final Map<String, Integer> scenarioIndentByTestCaseStartedId = new HashMap<String, Integer>();
    private final Set<Object> printedFeaturesAndRules = new HashSet<Object>();
    private final int afterFeatureIndent;
    private final int afterRuleIndent;
    private final int iconLength;

    PrettyReportData(Set<MessagesToPrettyWriter.PrettyFeature> features) {
        this.afterFeatureIndent = PrettyReportData.calculateAfterFeatureIndent(features);
        this.afterRuleIndent = PrettyReportData.calculateAfterRuleIndent(features);
        this.iconLength = PrettyReportData.calculateIconLength(features);
    }

    private static int calculateAfterRuleIndent(Set<MessagesToPrettyWriter.PrettyFeature> features) {
        int indent = 0;
        if (features.contains((Object)MessagesToPrettyWriter.PrettyFeature.INCLUDE_FEATURE_LINE)) {
            indent += 2;
        }
        if (features.contains((Object)MessagesToPrettyWriter.PrettyFeature.INCLUDE_RULE_LINE)) {
            indent += 2;
        }
        return indent;
    }

    private static int calculateAfterFeatureIndent(Set<MessagesToPrettyWriter.PrettyFeature> features) {
        int indent = 0;
        if (features.contains((Object)MessagesToPrettyWriter.PrettyFeature.INCLUDE_FEATURE_LINE)) {
            indent += 2;
        }
        return indent;
    }

    private static int calculateScenarioLineLength(int scenarioIndent, Pickle pickle, Scenario scenario) {
        String pickleName = pickle.getName();
        String pickleKeyword = scenario.getKeyword();
        return scenarioIndent + pickleKeyword.length() + 2 + pickleName.length();
    }

    private static int calculateIconLength(Set<MessagesToPrettyWriter.PrettyFeature> features) {
        return features.contains((Object)MessagesToPrettyWriter.PrettyFeature.USE_STATUS_ICON) ? 2 : 0;
    }

    private int calculateStepLineLength(int scenarioIndent, Step step, PickleStep pickleStep) {
        String keyword = step.getKeyword();
        String text = pickleStep.getText();
        return scenarioIndent + 2 + this.iconLength + keyword.length() + text.length();
    }

    private int calculateScenarioIndent(Lineage lineage) {
        if (lineage.rule().isPresent()) {
            return this.afterRuleIndent;
        }
        if (lineage.feature().isPresent()) {
            return this.afterFeatureIndent;
        }
        return 0;
    }

    void update(Envelope envelope) {
        this.query.update(envelope);
        envelope.getTestCaseStarted().ifPresent(this::preCalculateLocationIndent);
    }

    private void preCalculateLocationIndent(TestCaseStarted event) {
        this.query.findLineageBy(event).ifPresent(lineage -> lineage.scenario().ifPresent(scenario -> this.query.findPickleBy(event).ifPresent(pickle -> {
            int scenarioIndent = this.calculateScenarioIndent((Lineage)lineage);
            int scenarioLineLength = PrettyReportData.calculateScenarioLineLength(scenarioIndent, pickle, scenario);
            int longestLine = pickle.getSteps().stream().mapToInt(pickleStep -> this.preCalculatePickleStepLineLength(scenarioIndent, (PickleStep)pickleStep)).reduce(scenarioLineLength, Math::max);
            this.scenarioIndentByTestCaseStartedId.put(event.getId(), scenarioIndent);
            this.commentStartIndexByTestCaseStartedId.put(event.getId(), longestLine + 1);
        })));
    }

    private Integer preCalculatePickleStepLineLength(int indent, PickleStep pickleStep) {
        return this.query.findStepBy(pickleStep).map(step -> this.calculateStepLineLength(indent, (Step)step, pickleStep)).orElse(0);
    }

    int getAfterFeatureIndent() {
        return this.afterFeatureIndent;
    }

    int getAttachmentIndentBy(Attachment attachment) {
        return attachment.getTestCaseStartedId().map(this::getScenarioIndentBy).orElse(0) + 6 + this.iconLength;
    }

    int getScenarioIndentBy(TestCaseStarted testCaseStarted) {
        return this.getScenarioIndentBy(testCaseStarted.getId());
    }

    int getStepIndentBy(TestStepFinished testStepFinished) {
        return this.getScenarioIndentBy(testStepFinished.getTestCaseStartedId()) + 2;
    }

    private Integer getScenarioIndentBy(String testCaseStartedId) {
        return this.scenarioIndentByTestCaseStartedId.getOrDefault(testCaseStartedId, 0);
    }

    int getStackTraceIndentBy(TestStepFinished testStepFinished) {
        return this.getStepIndentBy(testStepFinished) + this.iconLength + 4;
    }

    int getArgumentIndentBy(TestStepFinished testStepFinished) {
        return this.getStepIndentBy(testStepFinished) + this.iconLength + 2;
    }

    int getCommentStartAtIndexBy(TestCaseStarted testCaseStarted) {
        return this.getCommentStartAtIndexBy(testCaseStarted.getId());
    }

    int getCommentStartAtIndexBy(TestStepFinished testStepFinished) {
        return this.getCommentStartAtIndexBy(testStepFinished.getTestCaseStartedId());
    }

    private int getCommentStartAtIndexBy(String testCaseStartedId) {
        return this.commentStartIndexByTestCaseStartedId.getOrDefault(testCaseStartedId, 0);
    }

    Optional<List<PickleTag>> findTagsBy(TestCaseStarted testCaseStarted) {
        return this.query.findPickleBy(testCaseStarted).map(Pickle::getTags).filter(pickleTags -> !pickleTags.isEmpty());
    }

    Optional<Scenario> findScenarioBy(Pickle pickle) {
        return this.query.findLineageBy(pickle).flatMap(Lineage::scenario);
    }

    Optional<TestStep> findTestStepBy(TestStepFinished event) {
        return this.query.findTestStepBy(event);
    }

    Optional<PickleStep> findPickleStepBy(TestStep testStep) {
        return this.query.findPickleStepBy(testStep);
    }

    Optional<Step> findStepBy(PickleStep pickleStep) {
        return this.query.findStepBy(pickleStep);
    }

    Optional<SourceReference> findSourceReferenceBy(TestStep testStep) {
        return this.query.findUnambiguousStepDefinitionBy(testStep).map(StepDefinition::getSourceReference);
    }

    Optional<Pickle> findPickleBy(TestCaseStarted testCaseStarted) {
        return this.query.findPickleBy(testCaseStarted);
    }

    Optional<Long> findLineOf(Pickle pickle) {
        return this.query.findLocationOf(pickle).map(Location::getLine);
    }

    Optional<Lineage> findLineageBy(TestCaseStarted event) {
        return this.query.findLineageBy(event);
    }

    void ifNotSeenBefore(Feature feature, Runnable print) {
        if (this.printedFeaturesAndRules.add(feature)) {
            print.run();
        }
    }

    void ifNotSeenBefore(Rule rule, Runnable print) {
        if (this.printedFeaturesAndRules.add(rule)) {
            print.run();
        }
    }
}

