/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.query;

import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.TableRow;
import io.cucumber.query.Lineage;
import io.cucumber.query.LineageReducer;
import java.util.Objects;
import java.util.function.Supplier;

class LineageReducerDescending<T>
implements LineageReducer<T> {
    private final Supplier<? extends LineageReducer.Collector<T>> collectorSupplier;

    LineageReducerDescending(Supplier<? extends LineageReducer.Collector<T>> collectorSupplier) {
        this.collectorSupplier = Objects.requireNonNull(collectorSupplier);
    }

    @Override
    public T reduce(Lineage lineage) {
        LineageReducer.Collector<T> collector = this.collectorSupplier.get();
        LineageReducerDescending.reduceAddLineage(collector, lineage);
        return collector.finish();
    }

    @Override
    public T reduce(Lineage lineage, Pickle pickle) {
        LineageReducer.Collector<T> collector = this.collectorSupplier.get();
        LineageReducerDescending.reduceAddLineage(collector, lineage);
        collector.add(pickle);
        return collector.finish();
    }

    private static <T> void reduceAddLineage(LineageReducer.Collector<T> collector, Lineage lineage) {
        collector.add(lineage.document());
        lineage.feature().ifPresent(collector::add);
        lineage.rule().ifPresent(collector::add);
        lineage.scenario().ifPresent(collector::add);
        lineage.examples().ifPresent(examples -> collector.add((Examples)examples, (int)lineage.examplesIndex().orElse(0)));
        lineage.example().ifPresent(example -> collector.add((TableRow)example, (int)lineage.exampleIndex().orElse(0)));
    }
}

