/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.testngxmlformatter;

import io.cucumber.messages.types.Envelope;
import io.cucumber.query.NamingStrategy;
import io.cucumber.testngxmlformatter.XmlReportData;
import io.cucumber.testngxmlformatter.XmlReportWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;

public class MessagesToTestngXmlWriter
implements AutoCloseable {
    private final OutputStreamWriter out;
    private final XmlReportData data;
    private boolean streamClosed = false;

    public MessagesToTestngXmlWriter(OutputStream out) {
        this(NamingStrategy.ExampleName.NUMBER_AND_PICKLE_IF_PARAMETERIZED, out);
    }

    public MessagesToTestngXmlWriter(NamingStrategy.ExampleName exampleNameStrategy, OutputStream out) {
        this(MessagesToTestngXmlWriter.createNamingStrategy(Objects.requireNonNull(exampleNameStrategy)), out);
    }

    private static NamingStrategy createNamingStrategy(NamingStrategy.ExampleName exampleName) {
        return NamingStrategy.strategy((NamingStrategy.Strategy)NamingStrategy.Strategy.LONG).featureName(NamingStrategy.FeatureName.EXCLUDE).exampleName(exampleName).build();
    }

    private MessagesToTestngXmlWriter(NamingStrategy namingStrategy, OutputStream out) {
        this.data = new XmlReportData(namingStrategy);
        this.out = new OutputStreamWriter(Objects.requireNonNull(out), StandardCharsets.UTF_8);
    }

    public void write(Envelope envelope) throws IOException {
        if (this.streamClosed) {
            throw new IOException("Stream closed");
        }
        this.data.collect(envelope);
    }

    @Override
    public void close() throws IOException {
        if (this.streamClosed) {
            return;
        }
        try {
            new XmlReportWriter(this.data).writeXmlReport(this.out);
        }
        catch (XMLStreamException e) {
            throw new IOException("Error while transforming.", e);
        }
        finally {
            try {
                this.out.close();
            }
            finally {
                this.streamClosed = true;
            }
        }
    }
}

