/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.usageformatter;

import io.cucumber.messages.Convertor;
import io.cucumber.usageformatter.UsageReport;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;

final class Durations {
    Durations() {
    }

    static UsageReport.Statistics createStatistics(List<Duration> durations) {
        if (durations.isEmpty()) {
            return null;
        }
        Duration sum = durations.stream().reduce(Duration::plus).orElse(Duration.ZERO);
        Duration mean = sum.dividedBy(durations.size());
        Duration moe95 = Durations.calculateMarginOfError95(durations, mean);
        return new UsageReport.Statistics(Convertor.toMessage((Duration)sum), Convertor.toMessage((Duration)mean), Convertor.toMessage((Duration)moe95));
    }

    private static Duration calculateMarginOfError95(List<Duration> durations, Duration mean) {
        BigDecimal meanSeconds = Durations.toBigDecimalSeconds(mean);
        BigDecimal variance = durations.stream().map(Durations::toBigDecimalSeconds).map(durationSeconds -> durationSeconds.subtract(meanSeconds).pow(2)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        double marginOfError = 2.0 * Math.sqrt(variance.doubleValue()) / (double)durations.size();
        long seconds = (long)Math.floor(marginOfError);
        long nanos = (long)Math.floor((marginOfError - (double)seconds) * (double)TimeUnit.SECONDS.toNanos(1L));
        return Duration.ofSeconds(seconds, nanos);
    }

    static BigDecimal toBigDecimalSeconds(Duration duration) {
        return BigDecimal.valueOf(duration.getSeconds()).add(BigDecimal.valueOf(duration.getNano(), 9));
    }

    static BigDecimal toBigDecimalSeconds(io.cucumber.messages.types.Duration duration) {
        return BigDecimal.valueOf(duration.getSeconds()).add(BigDecimal.valueOf(duration.getNanos(), 9));
    }
}

