/*
 * Decompiled with CFR 0.152.
 */
package zhttp.http;

import java.io.Serializable;
import java.security.MessageDigest;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import zhttp.http.Cookie$;
import zhttp.http.Cookie$SameSite$;
import zhttp.http.Path;
import zio.duration.package;

public final class Cookie
implements Product,
Serializable {
    private final String name;
    private final String content;
    private final Option expires;
    private final Option domain;
    private final Option path;
    private final boolean isSecure;
    private final boolean isHttpOnly;
    private final Option maxAge;
    private final Option sameSite;
    private final Option secret;

    public static Cookie apply(String string, String string2, Option<Instant> option, Option<String> option2, Option<Path> option3, boolean bl, boolean bl2, Option<Object> option4, Option<SameSite> option5, Option<String> option6) {
        return Cookie$.MODULE$.apply(string, string2, option, option2, option3, bl, bl2, option4, option5, option6);
    }

    public static List<Cookie> decodeRequestCookie(String string) {
        return Cookie$.MODULE$.decodeRequestCookie(string);
    }

    public static Option<Cookie> decodeResponseCookie(String string, Option<String> option) {
        return Cookie$.MODULE$.decodeResponseCookie(string, option);
    }

    public static Cookie fromProduct(Product product) {
        return Cookie$.MODULE$.fromProduct(product);
    }

    public static Cookie unapply(Cookie cookie) {
        return Cookie$.MODULE$.unapply(cookie);
    }

    public static Cookie unsafeDecodeResponseCookie(String string, Option<String> option) {
        return Cookie$.MODULE$.unsafeDecodeResponseCookie(string, option);
    }

    public static Option<String> decodeResponseCookie$default$2() {
        return Cookie$.MODULE$.decodeResponseCookie$default$2();
    }

    public static Option<String> unsafeDecodeResponseCookie$default$2() {
        return Cookie$.MODULE$.unsafeDecodeResponseCookie$default$2();
    }

    public static Option<Instant> $lessinit$greater$default$3() {
        return Cookie$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<String> $lessinit$greater$default$4() {
        return Cookie$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Path> $lessinit$greater$default$5() {
        return Cookie$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean $lessinit$greater$default$6() {
        return Cookie$.MODULE$.$lessinit$greater$default$6();
    }

    public static boolean $lessinit$greater$default$7() {
        return Cookie$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<Object> $lessinit$greater$default$8() {
        return Cookie$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<SameSite> $lessinit$greater$default$9() {
        return Cookie$.MODULE$.$lessinit$greater$default$9();
    }

    public static Option<String> $lessinit$greater$default$10() {
        return Cookie$.MODULE$.$lessinit$greater$default$10();
    }

    public Cookie(String name, String content, Option<Instant> expires, Option<String> domain, Option<Path> path, boolean isSecure, boolean isHttpOnly, Option<Object> maxAge, Option<SameSite> sameSite, Option<String> secret) {
        this.name = name;
        this.content = content;
        this.expires = expires;
        this.domain = domain;
        this.path = path;
        this.isSecure = isSecure;
        this.isHttpOnly = isHttpOnly;
        this.maxAge = maxAge;
        this.sameSite = sameSite;
        this.secret = secret;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.content()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.expires()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.domain()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.path()));
        n = Statics.mix((int)n, (int)(this.isSecure() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.isHttpOnly() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.maxAge()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.sameSite()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.secret()));
        return Statics.finalizeHash((int)n, (int)10);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Cookie)) return false;
        Cookie cookie = (Cookie)object;
        if (this.isSecure() != cookie.isSecure()) return false;
        if (this.isHttpOnly() != cookie.isHttpOnly()) return false;
        String string = this.name();
        String string2 = cookie.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.content();
        String string4 = cookie.content();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        Option<Instant> option = this.expires();
        Option<Instant> option2 = cookie.expires();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.domain();
        Option<String> option4 = cookie.domain();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<Path> option5 = this.path();
        Option<Path> option6 = cookie.path();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        Option<Object> option7 = this.maxAge();
        Option<Object> option8 = cookie.maxAge();
        if (option7 == null) {
            if (option8 != null) {
                return false;
            }
        } else if (!option7.equals(option8)) return false;
        Option<SameSite> option9 = this.sameSite();
        Option<SameSite> option10 = cookie.sameSite();
        if (option9 == null) {
            if (option10 != null) {
                return false;
            }
        } else if (!option9.equals(option10)) return false;
        Option<String> option11 = this.secret();
        Option<String> option12 = cookie.secret();
        if (option11 == null) {
            if (option12 == null) return true;
            return false;
        } else {
            if (!option11.equals(option12)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Cookie;
    }

    public int productArity() {
        return 10;
    }

    public String productPrefix() {
        return "Cookie";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            case 3: {
                object = this._4();
                break;
            }
            case 4: {
                object = this._5();
                break;
            }
            case 5: {
                object = BoxesRunTime.boxToBoolean((boolean)this._6());
                break;
            }
            case 6: {
                object = BoxesRunTime.boxToBoolean((boolean)this._7());
                break;
            }
            case 7: {
                object = this._8();
                break;
            }
            case 8: {
                object = this._9();
                break;
            }
            case 9: {
                object = this._10();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "name";
                break;
            }
            case 1: {
                string = "content";
                break;
            }
            case 2: {
                string = "expires";
                break;
            }
            case 3: {
                string = "domain";
                break;
            }
            case 4: {
                string = "path";
                break;
            }
            case 5: {
                string = "isSecure";
                break;
            }
            case 6: {
                string = "isHttpOnly";
                break;
            }
            case 7: {
                string = "maxAge";
                break;
            }
            case 8: {
                string = "sameSite";
                break;
            }
            case 9: {
                string = "secret";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public String name() {
        return this.name;
    }

    public String content() {
        return this.content;
    }

    public Option<Instant> expires() {
        return this.expires;
    }

    public Option<String> domain() {
        return this.domain;
    }

    public Option<Path> path() {
        return this.path;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public boolean isHttpOnly() {
        return this.isHttpOnly;
    }

    public Option<Object> maxAge() {
        return this.maxAge;
    }

    public Option<SameSite> sameSite() {
        return this.sameSite;
    }

    public Option<String> secret() {
        return this.secret;
    }

    public Cookie clear() {
        Some some = Some$.MODULE$.apply((Object)Instant.ofEpochSecond(0L));
        String string = this.copy$default$1();
        Option<String> option = this.copy$default$4();
        Option<Path> option2 = this.copy$default$5();
        boolean bl = this.copy$default$6();
        boolean bl2 = this.copy$default$7();
        Option<Object> option3 = this.copy$default$8();
        Option<SameSite> option4 = this.copy$default$9();
        Option<String> option5 = this.copy$default$10();
        return this.copy(string, "", (Option<Instant>)some, option, option2, bl, bl2, option3, option4, option5);
    }

    public Cookie withContent(String v) {
        return this.copy(this.copy$default$1(), v, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public Cookie withExpiry(Instant v) {
        Some some = Some$.MODULE$.apply((Object)v);
        String string = this.copy$default$1();
        String string2 = this.copy$default$2();
        Option<String> option = this.copy$default$4();
        Option<Path> option2 = this.copy$default$5();
        boolean bl = this.copy$default$6();
        boolean bl2 = this.copy$default$7();
        Option<Object> option3 = this.copy$default$8();
        Option<SameSite> option4 = this.copy$default$9();
        Option<String> option5 = this.copy$default$10();
        return this.copy(string, string2, (Option<Instant>)some, option, option2, bl, bl2, option3, option4, option5);
    }

    public Cookie withMaxAge(Duration v) {
        Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)package.DurationOps$.MODULE$.asScala$extension(zio.duration.package$.MODULE$.DurationOps(v)).toSeconds()));
        String string = this.copy$default$1();
        String string2 = this.copy$default$2();
        Option<Instant> option = this.copy$default$3();
        Option<String> option2 = this.copy$default$4();
        Option<Path> option3 = this.copy$default$5();
        boolean bl = this.copy$default$6();
        boolean bl2 = this.copy$default$7();
        Option<SameSite> option4 = this.copy$default$9();
        Option<String> option5 = this.copy$default$10();
        return this.copy(string, string2, option, option2, option3, bl, bl2, (Option<Object>)some, option4, option5);
    }

    public Cookie withMaxAge(long v) {
        Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)v));
        String string = this.copy$default$1();
        String string2 = this.copy$default$2();
        Option<Instant> option = this.copy$default$3();
        Option<String> option2 = this.copy$default$4();
        Option<Path> option3 = this.copy$default$5();
        boolean bl = this.copy$default$6();
        boolean bl2 = this.copy$default$7();
        Option<SameSite> option4 = this.copy$default$9();
        Option<String> option5 = this.copy$default$10();
        return this.copy(string, string2, option, option2, option3, bl, bl2, (Option<Object>)some, option4, option5);
    }

    public Cookie withDomain(String v) {
        Some some = Some$.MODULE$.apply((Object)v);
        String string = this.copy$default$1();
        String string2 = this.copy$default$2();
        Option<Instant> option = this.copy$default$3();
        Option<Path> option2 = this.copy$default$5();
        boolean bl = this.copy$default$6();
        boolean bl2 = this.copy$default$7();
        Option<Object> option3 = this.copy$default$8();
        Option<SameSite> option4 = this.copy$default$9();
        Option<String> option5 = this.copy$default$10();
        return this.copy(string, string2, option, (Option<String>)some, option2, bl, bl2, option3, option4, option5);
    }

    public Cookie withPath(Path v) {
        Some some = Some$.MODULE$.apply((Object)v);
        String string = this.copy$default$1();
        String string2 = this.copy$default$2();
        Option<Instant> option = this.copy$default$3();
        Option<String> option2 = this.copy$default$4();
        boolean bl = this.copy$default$6();
        boolean bl2 = this.copy$default$7();
        Option<Object> option3 = this.copy$default$8();
        Option<SameSite> option4 = this.copy$default$9();
        Option<String> option5 = this.copy$default$10();
        return this.copy(string, string2, option, option2, (Option<Path>)some, bl, bl2, option3, option4, option5);
    }

    public Cookie withSecure() {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), true, this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public Cookie withHttpOnly() {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), true, this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public Cookie withSameSite(SameSite v) {
        Some some = Some$.MODULE$.apply((Object)v);
        String string = this.copy$default$1();
        String string2 = this.copy$default$2();
        Option<Instant> option = this.copy$default$3();
        Option<String> option2 = this.copy$default$4();
        Option<Path> option3 = this.copy$default$5();
        boolean bl = this.copy$default$6();
        boolean bl2 = this.copy$default$7();
        Option<Object> option4 = this.copy$default$8();
        Option<String> option5 = this.copy$default$10();
        return this.copy(string, string2, option, option2, option3, bl, bl2, option4, (Option<SameSite>)some, option5);
    }

    public Cookie sign(String secret) {
        Some some = Some$.MODULE$.apply((Object)secret);
        String string = this.copy$default$1();
        String string2 = this.copy$default$2();
        Option<Instant> option = this.copy$default$3();
        Option<String> option2 = this.copy$default$4();
        Option<Path> option3 = this.copy$default$5();
        boolean bl = this.copy$default$6();
        boolean bl2 = this.copy$default$7();
        Option<Object> option4 = this.copy$default$8();
        Option<SameSite> option5 = this.copy$default$9();
        return this.copy(string, string2, option, option2, option3, bl, bl2, option4, option5, (Option<String>)some);
    }

    public Cookie unSign() {
        None$ none$ = None$.MODULE$;
        String string = this.copy$default$1();
        String string2 = this.copy$default$2();
        Option<Instant> option = this.copy$default$3();
        Option<String> option2 = this.copy$default$4();
        Option<Path> option3 = this.copy$default$5();
        boolean bl = this.copy$default$6();
        boolean bl2 = this.copy$default$7();
        Option<Object> option4 = this.copy$default$8();
        Option<SameSite> option5 = this.copy$default$9();
        return this.copy(string, string2, option, option2, option3, bl, bl2, option4, option5, (Option<String>)none$);
    }

    public Cookie withoutSecure() {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), false, this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public Cookie withoutHttpOnly() {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), false, this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public Cookie withoutExpiry() {
        None$ none$ = None$.MODULE$;
        String string = this.copy$default$1();
        String string2 = this.copy$default$2();
        Option<String> option = this.copy$default$4();
        Option<Path> option2 = this.copy$default$5();
        boolean bl = this.copy$default$6();
        boolean bl2 = this.copy$default$7();
        Option<Object> option3 = this.copy$default$8();
        Option<SameSite> option4 = this.copy$default$9();
        Option<String> option5 = this.copy$default$10();
        return this.copy(string, string2, (Option<Instant>)none$, option, option2, bl, bl2, option3, option4, option5);
    }

    public Cookie withoutDomain() {
        None$ none$ = None$.MODULE$;
        String string = this.copy$default$1();
        String string2 = this.copy$default$2();
        Option<Instant> option = this.copy$default$3();
        Option<Path> option2 = this.copy$default$5();
        boolean bl = this.copy$default$6();
        boolean bl2 = this.copy$default$7();
        Option<Object> option3 = this.copy$default$8();
        Option<SameSite> option4 = this.copy$default$9();
        Option<String> option5 = this.copy$default$10();
        return this.copy(string, string2, option, (Option<String>)none$, option2, bl, bl2, option3, option4, option5);
    }

    public Cookie withoutPath() {
        None$ none$ = None$.MODULE$;
        String string = this.copy$default$1();
        String string2 = this.copy$default$2();
        Option<Instant> option = this.copy$default$3();
        Option<String> option2 = this.copy$default$4();
        boolean bl = this.copy$default$6();
        boolean bl2 = this.copy$default$7();
        Option<Object> option3 = this.copy$default$8();
        Option<SameSite> option4 = this.copy$default$9();
        Option<String> option5 = this.copy$default$10();
        return this.copy(string, string2, option, option2, (Option<Path>)none$, bl, bl2, option3, option4, option5);
    }

    public Cookie withoutMaxAge() {
        None$ none$ = None$.MODULE$;
        String string = this.copy$default$1();
        String string2 = this.copy$default$2();
        Option<Instant> option = this.copy$default$3();
        Option<String> option2 = this.copy$default$4();
        Option<Path> option3 = this.copy$default$5();
        boolean bl = this.copy$default$6();
        boolean bl2 = this.copy$default$7();
        Option<SameSite> option4 = this.copy$default$9();
        Option<String> option5 = this.copy$default$10();
        return this.copy(string, string2, option, option2, option3, bl, bl2, (Option<Object>)none$, option4, option5);
    }

    public Cookie withoutSameSite() {
        None$ none$ = None$.MODULE$;
        String string = this.copy$default$1();
        String string2 = this.copy$default$2();
        Option<Instant> option = this.copy$default$3();
        Option<String> option2 = this.copy$default$4();
        Option<Path> option3 = this.copy$default$5();
        boolean bl = this.copy$default$6();
        boolean bl2 = this.copy$default$7();
        Option<Object> option4 = this.copy$default$8();
        Option<String> option5 = this.copy$default$10();
        return this.copy(string, string2, option, option2, option3, bl, bl2, option4, (Option<SameSite>)none$, option5);
    }

    public String encode() {
        String sec;
        Option<String> option = this.secret();
        String c = option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(sec = (String)((Some)option).value())) ? new StringBuilder(1).append(this.content()).append(".").append(this.signContent(sec)).toString() : this.content();
        List cookie = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{Some$.MODULE$.apply((Object)new StringBuilder(1).append(this.name()).append("=").append(c).toString()), this.expires().map((Function1 & Serializable)e -> new StringBuilder(8).append("Expires=").append(e).toString()), this.maxAge().map((Function1 & Serializable)a -> Cookie.$anonfun$2(BoxesRunTime.unboxToLong((Object)a))), this.domain().filter((Function1 & Serializable)_$1 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$1))).map((Function1 & Serializable)d -> new StringBuilder(7).append("Domain=").append((String)d).toString()), this.path().filter((Function1 & Serializable)_$2 -> _$2.nonEmpty()).map((Function1 & Serializable)p -> new StringBuilder(5).append("Path=").append(p.encode()).toString()), this.isSecure() ? Some$.MODULE$.apply((Object)"Secure") : None$.MODULE$, this.isHttpOnly() ? Some$.MODULE$.apply((Object)"HttpOnly") : None$.MODULE$, this.sameSite().map((Function1 & Serializable)s -> new StringBuilder(9).append("SameSite=").append(s.asString()).toString())}));
        return ((IterableOnceOps)cookie.flatten(Predef$.MODULE$.$conforms())).mkString("; ");
    }

    private String signContent(String secret) {
        Mac sha256 = Mac.getInstance("HmacSHA256");
        SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(), "RSA");
        sha256.init(secretKey);
        byte[] signed = sha256.doFinal(this.content().getBytes());
        MessageDigest mda = MessageDigest.getInstance("SHA-512");
        return Base64.getEncoder().encodeToString(mda.digest(signed));
    }

    public boolean zhttp$http$Cookie$$verify(String content, String signature, String secret) {
        String string = this.withContent(content).signContent(secret);
        String string2 = signature;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public Cookie copy(String name, String content, Option<Instant> expires, Option<String> domain, Option<Path> path, boolean isSecure, boolean isHttpOnly, Option<Object> maxAge, Option<SameSite> sameSite, Option<String> secret) {
        return new Cookie(name, content, expires, domain, path, isSecure, isHttpOnly, maxAge, sameSite, secret);
    }

    public String copy$default$1() {
        return this.name();
    }

    public String copy$default$2() {
        return this.content();
    }

    public Option<Instant> copy$default$3() {
        return this.expires();
    }

    public Option<String> copy$default$4() {
        return this.domain();
    }

    public Option<Path> copy$default$5() {
        return this.path();
    }

    public boolean copy$default$6() {
        return this.isSecure();
    }

    public boolean copy$default$7() {
        return this.isHttpOnly();
    }

    public Option<Object> copy$default$8() {
        return this.maxAge();
    }

    public Option<SameSite> copy$default$9() {
        return this.sameSite();
    }

    public Option<String> copy$default$10() {
        return this.secret();
    }

    public String _1() {
        return this.name();
    }

    public String _2() {
        return this.content();
    }

    public Option<Instant> _3() {
        return this.expires();
    }

    public Option<String> _4() {
        return this.domain();
    }

    public Option<Path> _5() {
        return this.path();
    }

    public boolean _6() {
        return this.isSecure();
    }

    public boolean _7() {
        return this.isHttpOnly();
    }

    public Option<Object> _8() {
        return this.maxAge();
    }

    public Option<SameSite> _9() {
        return this.sameSite();
    }

    public Option<String> _10() {
        return this.secret();
    }

    private static final /* synthetic */ String $anonfun$2(long a) {
        return new StringBuilder(8).append("Max-Age=").append(BoxesRunTime.boxToLong((long)a).toString()).toString();
    }

    public static interface SameSite {
        public static int ordinal(SameSite sameSite) {
            return Cookie$SameSite$.MODULE$.ordinal(sameSite);
        }

        public String asString();
    }
}

