/*
 * Decompiled with CFR 0.152.
 */
package zhttp.http;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import zhttp.http.HttpError$;
import zhttp.http.HttpError$BadGateway$;
import zhttp.http.HttpError$BadRequest$;
import zhttp.http.HttpError$Conflict$;
import zhttp.http.HttpError$Custom$;
import zhttp.http.HttpError$ExpectationFailed$;
import zhttp.http.HttpError$FailedDependency$;
import zhttp.http.HttpError$Forbidden$;
import zhttp.http.HttpError$GatewayTimeout$;
import zhttp.http.HttpError$Gone$;
import zhttp.http.HttpError$HttpVersionNotSupported$;
import zhttp.http.HttpError$InsufficientStorage$;
import zhttp.http.HttpError$InternalServerError$;
import zhttp.http.HttpError$LengthRequired$;
import zhttp.http.HttpError$Locked$;
import zhttp.http.HttpError$MethodNotAllowed$;
import zhttp.http.HttpError$MisdirectedRequest$;
import zhttp.http.HttpError$NetworkAuthenticationRequired$;
import zhttp.http.HttpError$NotAcceptable$;
import zhttp.http.HttpError$NotExtended$;
import zhttp.http.HttpError$NotFound$;
import zhttp.http.HttpError$NotImplemented$;
import zhttp.http.HttpError$PaymentRequired$;
import zhttp.http.HttpError$PreconditionFailed$;
import zhttp.http.HttpError$PreconditionRequired$;
import zhttp.http.HttpError$ProxyAuthenticationRequired$;
import zhttp.http.HttpError$RequestEntityTooLarge$;
import zhttp.http.HttpError$RequestHeaderFieldsTooLarge$;
import zhttp.http.HttpError$RequestTimeout$;
import zhttp.http.HttpError$RequestUriTooLong$;
import zhttp.http.HttpError$RequestedRangeNotSatisfiable$;
import zhttp.http.HttpError$ServiceUnavailable$;
import zhttp.http.HttpError$TooManyRequests$;
import zhttp.http.HttpError$Unauthorized$;
import zhttp.http.HttpError$UnorderedCollection$;
import zhttp.http.HttpError$UnprocessableEntity$;
import zhttp.http.HttpError$UnsupportedMediaType$;
import zhttp.http.HttpError$UpgradeRequired$;
import zhttp.http.HttpError$VariantAlsoNegotiates$;
import zhttp.http.Path;
import zhttp.http.Response;
import zhttp.http.Response$;
import zhttp.http.Status;
import zhttp.http.Status$BadGateway$;
import zhttp.http.Status$BadRequest$;
import zhttp.http.Status$Conflict$;
import zhttp.http.Status$Custom$;
import zhttp.http.Status$ExpectationFailed$;
import zhttp.http.Status$FailedDependency$;
import zhttp.http.Status$Forbidden$;
import zhttp.http.Status$GatewayTimeout$;
import zhttp.http.Status$Gone$;
import zhttp.http.Status$HttpVersionNotSupported$;
import zhttp.http.Status$InsufficientStorage$;
import zhttp.http.Status$InternalServerError$;
import zhttp.http.Status$LengthRequired$;
import zhttp.http.Status$Locked$;
import zhttp.http.Status$MethodNotAllowed$;
import zhttp.http.Status$MisdirectedRequest$;
import zhttp.http.Status$NetworkAuthenticationRequired$;
import zhttp.http.Status$NotAcceptable$;
import zhttp.http.Status$NotExtended$;
import zhttp.http.Status$NotFound$;
import zhttp.http.Status$NotImplemented$;
import zhttp.http.Status$PaymentRequired$;
import zhttp.http.Status$PreconditionFailed$;
import zhttp.http.Status$PreconditionRequired$;
import zhttp.http.Status$ProxyAuthenticationRequired$;
import zhttp.http.Status$RequestEntityTooLarge$;
import zhttp.http.Status$RequestHeaderFieldsTooLarge$;
import zhttp.http.Status$RequestTimeout$;
import zhttp.http.Status$RequestUriTooLong$;
import zhttp.http.Status$RequestedRangeNotSatisfiable$;
import zhttp.http.Status$ServiceUnavailable$;
import zhttp.http.Status$TooManyRequests$;
import zhttp.http.Status$Unauthorized$;
import zhttp.http.Status$UnorderedCollection$;
import zhttp.http.Status$UnprocessableEntity$;
import zhttp.http.Status$UnsupportedMediaType$;
import zhttp.http.Status$UpgradeRequired$;
import zhttp.http.Status$VariantAlsoNegotiates$;

public abstract class HttpError
extends Throwable {
    private final Status status;
    private final String message;

    public static Option<Tuple2<Status, String>> unapply(Throwable throwable) {
        return HttpError$.MODULE$.unapply(throwable);
    }

    public HttpError(Status status, String message) {
        this.status = status;
        this.message = message;
        super(message);
    }

    public Status status() {
        return this.status;
    }

    public String message() {
        return this.message;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <A> A foldCause(A a, Function1<Throwable, A> f) {
        Object object;
        HttpError httpError = this;
        if (httpError instanceof HTTPErrorWithCause) {
            HTTPErrorWithCause error = (HTTPErrorWithCause)httpError;
            Option<Throwable> option = error.cause();
            if (option instanceof Some) {
                Throwable throwable = (Throwable)((Some)option).value();
                object = f.apply((Object)throwable);
                return object;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                object = a;
            }
            return object;
        } else {
            object = a;
        }
        return object;
    }

    public Response toResponse() {
        return Response$.MODULE$.fromHttpError(this);
    }

    public static final class BadGateway
    extends HttpError
    implements Product {
        private final String msg;

        public static BadGateway apply(String string) {
            return HttpError$BadGateway$.MODULE$.apply(string);
        }

        public static BadGateway fromProduct(Product product) {
            return HttpError$BadGateway$.MODULE$.fromProduct(product);
        }

        public static BadGateway unapply(BadGateway badGateway) {
            return HttpError$BadGateway$.MODULE$.unapply(badGateway);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$BadGateway$.MODULE$.$lessinit$greater$default$1();
        }

        public BadGateway(String msg) {
            this.msg = msg;
            super(Status$BadGateway$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BadGateway)) return false;
            BadGateway badGateway = (BadGateway)object;
            String string = this.msg();
            String string2 = badGateway.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof BadGateway;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "BadGateway";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public BadGateway copy(String msg) {
            return new BadGateway(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class BadRequest
    extends HttpError
    implements Product {
        private final String msg;

        public static BadRequest apply(String string) {
            return HttpError$BadRequest$.MODULE$.apply(string);
        }

        public static BadRequest fromProduct(Product product) {
            return HttpError$BadRequest$.MODULE$.fromProduct(product);
        }

        public static BadRequest unapply(BadRequest badRequest) {
            return HttpError$BadRequest$.MODULE$.unapply(badRequest);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$BadRequest$.MODULE$.$lessinit$greater$default$1();
        }

        public BadRequest(String msg) {
            this.msg = msg;
            super(Status$BadRequest$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BadRequest)) return false;
            BadRequest badRequest = (BadRequest)object;
            String string = this.msg();
            String string2 = badRequest.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof BadRequest;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "BadRequest";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public BadRequest copy(String msg) {
            return new BadRequest(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class Conflict
    extends HttpError
    implements Product {
        private final String msg;

        public static Conflict apply(String string) {
            return HttpError$Conflict$.MODULE$.apply(string);
        }

        public static Conflict fromProduct(Product product) {
            return HttpError$Conflict$.MODULE$.fromProduct(product);
        }

        public static Conflict unapply(Conflict conflict) {
            return HttpError$Conflict$.MODULE$.unapply(conflict);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$Conflict$.MODULE$.$lessinit$greater$default$1();
        }

        public Conflict(String msg) {
            this.msg = msg;
            super(Status$Conflict$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Conflict)) return false;
            Conflict conflict = (Conflict)object;
            String string = this.msg();
            String string2 = conflict.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Conflict;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Conflict";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public Conflict copy(String msg) {
            return new Conflict(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class Custom
    extends HttpError
    implements Product {
        private final int code;
        private final String reason;

        public static Custom apply(int n, String string) {
            return HttpError$Custom$.MODULE$.apply(n, string);
        }

        public static Custom fromProduct(Product product) {
            return HttpError$Custom$.MODULE$.fromProduct(product);
        }

        public static Custom unapply(Custom custom) {
            return HttpError$Custom$.MODULE$.unapply(custom);
        }

        public Custom(int code, String reason) {
            this.code = code;
            this.reason = reason;
            super(Status$Custom$.MODULE$.apply(code), reason);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.code());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.reason()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Custom)) return false;
            Custom custom = (Custom)object;
            if (this.code() != custom.code()) return false;
            String string = this.reason();
            String string2 = custom.reason();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Custom;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Custom";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = BoxesRunTime.boxToInteger((int)this._1());
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "code";
            } else if (1 == n2) {
                string = "reason";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public int code() {
            return this.code;
        }

        public String reason() {
            return this.reason;
        }

        public Custom copy(int code, String reason) {
            return new Custom(code, reason);
        }

        public int copy$default$1() {
            return this.code();
        }

        public String copy$default$2() {
            return this.reason();
        }

        public int _1() {
            return this.code();
        }

        public String _2() {
            return this.reason();
        }
    }

    public static final class ExpectationFailed
    extends HttpError
    implements Product {
        private final String msg;

        public static ExpectationFailed apply(String string) {
            return HttpError$ExpectationFailed$.MODULE$.apply(string);
        }

        public static ExpectationFailed fromProduct(Product product) {
            return HttpError$ExpectationFailed$.MODULE$.fromProduct(product);
        }

        public static ExpectationFailed unapply(ExpectationFailed expectationFailed) {
            return HttpError$ExpectationFailed$.MODULE$.unapply(expectationFailed);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$ExpectationFailed$.MODULE$.$lessinit$greater$default$1();
        }

        public ExpectationFailed(String msg) {
            this.msg = msg;
            super(Status$ExpectationFailed$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ExpectationFailed)) return false;
            ExpectationFailed expectationFailed = (ExpectationFailed)object;
            String string = this.msg();
            String string2 = expectationFailed.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof ExpectationFailed;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ExpectationFailed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public ExpectationFailed copy(String msg) {
            return new ExpectationFailed(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class FailedDependency
    extends HttpError
    implements Product {
        private final String msg;

        public static FailedDependency apply(String string) {
            return HttpError$FailedDependency$.MODULE$.apply(string);
        }

        public static FailedDependency fromProduct(Product product) {
            return HttpError$FailedDependency$.MODULE$.fromProduct(product);
        }

        public static FailedDependency unapply(FailedDependency failedDependency) {
            return HttpError$FailedDependency$.MODULE$.unapply(failedDependency);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$FailedDependency$.MODULE$.$lessinit$greater$default$1();
        }

        public FailedDependency(String msg) {
            this.msg = msg;
            super(Status$FailedDependency$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FailedDependency)) return false;
            FailedDependency failedDependency = (FailedDependency)object;
            String string = this.msg();
            String string2 = failedDependency.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof FailedDependency;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "FailedDependency";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public FailedDependency copy(String msg) {
            return new FailedDependency(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class Forbidden
    extends HttpError
    implements Product {
        private final String msg;

        public static Forbidden apply(String string) {
            return HttpError$Forbidden$.MODULE$.apply(string);
        }

        public static Forbidden fromProduct(Product product) {
            return HttpError$Forbidden$.MODULE$.fromProduct(product);
        }

        public static Forbidden unapply(Forbidden forbidden) {
            return HttpError$Forbidden$.MODULE$.unapply(forbidden);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$Forbidden$.MODULE$.$lessinit$greater$default$1();
        }

        public Forbidden(String msg) {
            this.msg = msg;
            super(Status$Forbidden$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Forbidden)) return false;
            Forbidden forbidden = (Forbidden)object;
            String string = this.msg();
            String string2 = forbidden.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Forbidden;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Forbidden";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public Forbidden copy(String msg) {
            return new Forbidden(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class GatewayTimeout
    extends HttpError
    implements Product {
        private final String msg;

        public static GatewayTimeout apply(String string) {
            return HttpError$GatewayTimeout$.MODULE$.apply(string);
        }

        public static GatewayTimeout fromProduct(Product product) {
            return HttpError$GatewayTimeout$.MODULE$.fromProduct(product);
        }

        public static GatewayTimeout unapply(GatewayTimeout gatewayTimeout) {
            return HttpError$GatewayTimeout$.MODULE$.unapply(gatewayTimeout);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$GatewayTimeout$.MODULE$.$lessinit$greater$default$1();
        }

        public GatewayTimeout(String msg) {
            this.msg = msg;
            super(Status$GatewayTimeout$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof GatewayTimeout)) return false;
            GatewayTimeout gatewayTimeout = (GatewayTimeout)object;
            String string = this.msg();
            String string2 = gatewayTimeout.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof GatewayTimeout;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "GatewayTimeout";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public GatewayTimeout copy(String msg) {
            return new GatewayTimeout(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class Gone
    extends HttpError
    implements Product {
        private final String msg;

        public static Gone apply(String string) {
            return HttpError$Gone$.MODULE$.apply(string);
        }

        public static Gone fromProduct(Product product) {
            return HttpError$Gone$.MODULE$.fromProduct(product);
        }

        public static Gone unapply(Gone gone) {
            return HttpError$Gone$.MODULE$.unapply(gone);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$Gone$.MODULE$.$lessinit$greater$default$1();
        }

        public Gone(String msg) {
            this.msg = msg;
            super(Status$Gone$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Gone)) return false;
            Gone gone = (Gone)object;
            String string = this.msg();
            String string2 = gone.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Gone;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Gone";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public Gone copy(String msg) {
            return new Gone(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static abstract class HTTPErrorWithCause
    extends HttpError {
        public HTTPErrorWithCause(Status status, String msg) {
            super(status, msg);
            this.cause().foreach((Function1 & Serializable)x$0 -> this.initCause((Throwable)x$0));
        }

        private Status status$accessor() {
            return super.status();
        }

        public abstract Option<Throwable> cause();
    }

    public static final class HttpVersionNotSupported
    extends HttpError
    implements Product {
        private final String msg;

        public static HttpVersionNotSupported apply(String string) {
            return HttpError$HttpVersionNotSupported$.MODULE$.apply(string);
        }

        public static HttpVersionNotSupported fromProduct(Product product) {
            return HttpError$HttpVersionNotSupported$.MODULE$.fromProduct(product);
        }

        public static HttpVersionNotSupported unapply(HttpVersionNotSupported httpVersionNotSupported) {
            return HttpError$HttpVersionNotSupported$.MODULE$.unapply(httpVersionNotSupported);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$HttpVersionNotSupported$.MODULE$.$lessinit$greater$default$1();
        }

        public HttpVersionNotSupported(String msg) {
            this.msg = msg;
            super(Status$HttpVersionNotSupported$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof HttpVersionNotSupported)) return false;
            HttpVersionNotSupported httpVersionNotSupported = (HttpVersionNotSupported)object;
            String string = this.msg();
            String string2 = httpVersionNotSupported.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof HttpVersionNotSupported;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "HttpVersionNotSupported";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public HttpVersionNotSupported copy(String msg) {
            return new HttpVersionNotSupported(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class InsufficientStorage
    extends HttpError
    implements Product {
        private final String msg;

        public static InsufficientStorage apply(String string) {
            return HttpError$InsufficientStorage$.MODULE$.apply(string);
        }

        public static InsufficientStorage fromProduct(Product product) {
            return HttpError$InsufficientStorage$.MODULE$.fromProduct(product);
        }

        public static InsufficientStorage unapply(InsufficientStorage insufficientStorage) {
            return HttpError$InsufficientStorage$.MODULE$.unapply(insufficientStorage);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$InsufficientStorage$.MODULE$.$lessinit$greater$default$1();
        }

        public InsufficientStorage(String msg) {
            this.msg = msg;
            super(Status$InsufficientStorage$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof InsufficientStorage)) return false;
            InsufficientStorage insufficientStorage = (InsufficientStorage)object;
            String string = this.msg();
            String string2 = insufficientStorage.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof InsufficientStorage;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "InsufficientStorage";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public InsufficientStorage copy(String msg) {
            return new InsufficientStorage(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class InternalServerError
    extends HTTPErrorWithCause
    implements Product {
        private final String msg;
        private final Option cause;

        public static InternalServerError apply(String string, Option<Throwable> option) {
            return HttpError$InternalServerError$.MODULE$.apply(string, option);
        }

        public static InternalServerError fromProduct(Product product) {
            return HttpError$InternalServerError$.MODULE$.fromProduct(product);
        }

        public static InternalServerError unapply(InternalServerError internalServerError) {
            return HttpError$InternalServerError$.MODULE$.unapply(internalServerError);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$InternalServerError$.MODULE$.$lessinit$greater$default$1();
        }

        public static Option<Throwable> $lessinit$greater$default$2() {
            return HttpError$InternalServerError$.MODULE$.$lessinit$greater$default$2();
        }

        public InternalServerError(String msg, Option<Throwable> cause) {
            this.msg = msg;
            this.cause = cause;
            super(Status$InternalServerError$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof InternalServerError)) return false;
            InternalServerError internalServerError = (InternalServerError)object;
            String string = this.msg();
            String string2 = internalServerError.msg();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<Throwable> option = this.cause();
            Option<Throwable> option2 = internalServerError.cause();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof InternalServerError;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "InternalServerError";
        }

        public Object productElement(int n) {
            Option<Throwable> option;
            int n2 = n;
            if (0 == n2) {
                option = this._1();
            } else if (1 == n2) {
                option = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return option;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "msg";
            } else if (1 == n2) {
                string = "cause";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public String msg() {
            return this.msg;
        }

        @Override
        public Option<Throwable> cause() {
            return this.cause;
        }

        public InternalServerError copy(String msg, Option<Throwable> cause) {
            return new InternalServerError(msg, cause);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public Option<Throwable> copy$default$2() {
            return this.cause();
        }

        public String _1() {
            return this.msg();
        }

        public Option<Throwable> _2() {
            return this.cause();
        }
    }

    public static final class LengthRequired
    extends HttpError
    implements Product {
        private final String msg;

        public static LengthRequired apply(String string) {
            return HttpError$LengthRequired$.MODULE$.apply(string);
        }

        public static LengthRequired fromProduct(Product product) {
            return HttpError$LengthRequired$.MODULE$.fromProduct(product);
        }

        public static LengthRequired unapply(LengthRequired lengthRequired) {
            return HttpError$LengthRequired$.MODULE$.unapply(lengthRequired);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$LengthRequired$.MODULE$.$lessinit$greater$default$1();
        }

        public LengthRequired(String msg) {
            this.msg = msg;
            super(Status$LengthRequired$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LengthRequired)) return false;
            LengthRequired lengthRequired = (LengthRequired)object;
            String string = this.msg();
            String string2 = lengthRequired.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof LengthRequired;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "LengthRequired";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public LengthRequired copy(String msg) {
            return new LengthRequired(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class Locked
    extends HttpError
    implements Product {
        private final String msg;

        public static Locked apply(String string) {
            return HttpError$Locked$.MODULE$.apply(string);
        }

        public static Locked fromProduct(Product product) {
            return HttpError$Locked$.MODULE$.fromProduct(product);
        }

        public static Locked unapply(Locked locked) {
            return HttpError$Locked$.MODULE$.unapply(locked);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$Locked$.MODULE$.$lessinit$greater$default$1();
        }

        public Locked(String msg) {
            this.msg = msg;
            super(Status$Locked$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Locked)) return false;
            Locked locked = (Locked)object;
            String string = this.msg();
            String string2 = locked.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Locked;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Locked";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public Locked copy(String msg) {
            return new Locked(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class MethodNotAllowed
    extends HttpError
    implements Product {
        private final String msg;

        public static MethodNotAllowed apply(String string) {
            return HttpError$MethodNotAllowed$.MODULE$.apply(string);
        }

        public static MethodNotAllowed fromProduct(Product product) {
            return HttpError$MethodNotAllowed$.MODULE$.fromProduct(product);
        }

        public static MethodNotAllowed unapply(MethodNotAllowed methodNotAllowed) {
            return HttpError$MethodNotAllowed$.MODULE$.unapply(methodNotAllowed);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$MethodNotAllowed$.MODULE$.$lessinit$greater$default$1();
        }

        public MethodNotAllowed(String msg) {
            this.msg = msg;
            super(Status$MethodNotAllowed$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MethodNotAllowed)) return false;
            MethodNotAllowed methodNotAllowed = (MethodNotAllowed)object;
            String string = this.msg();
            String string2 = methodNotAllowed.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof MethodNotAllowed;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MethodNotAllowed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public MethodNotAllowed copy(String msg) {
            return new MethodNotAllowed(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class MisdirectedRequest
    extends HttpError
    implements Product {
        private final String msg;

        public static MisdirectedRequest apply(String string) {
            return HttpError$MisdirectedRequest$.MODULE$.apply(string);
        }

        public static MisdirectedRequest fromProduct(Product product) {
            return HttpError$MisdirectedRequest$.MODULE$.fromProduct(product);
        }

        public static MisdirectedRequest unapply(MisdirectedRequest misdirectedRequest) {
            return HttpError$MisdirectedRequest$.MODULE$.unapply(misdirectedRequest);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$MisdirectedRequest$.MODULE$.$lessinit$greater$default$1();
        }

        public MisdirectedRequest(String msg) {
            this.msg = msg;
            super(Status$MisdirectedRequest$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MisdirectedRequest)) return false;
            MisdirectedRequest misdirectedRequest = (MisdirectedRequest)object;
            String string = this.msg();
            String string2 = misdirectedRequest.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof MisdirectedRequest;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MisdirectedRequest";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public MisdirectedRequest copy(String msg) {
            return new MisdirectedRequest(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class NetworkAuthenticationRequired
    extends HttpError
    implements Product {
        private final String msg;

        public static NetworkAuthenticationRequired apply(String string) {
            return HttpError$NetworkAuthenticationRequired$.MODULE$.apply(string);
        }

        public static NetworkAuthenticationRequired fromProduct(Product product) {
            return HttpError$NetworkAuthenticationRequired$.MODULE$.fromProduct(product);
        }

        public static NetworkAuthenticationRequired unapply(NetworkAuthenticationRequired networkAuthenticationRequired) {
            return HttpError$NetworkAuthenticationRequired$.MODULE$.unapply(networkAuthenticationRequired);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$NetworkAuthenticationRequired$.MODULE$.$lessinit$greater$default$1();
        }

        public NetworkAuthenticationRequired(String msg) {
            this.msg = msg;
            super(Status$NetworkAuthenticationRequired$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NetworkAuthenticationRequired)) return false;
            NetworkAuthenticationRequired networkAuthenticationRequired = (NetworkAuthenticationRequired)object;
            String string = this.msg();
            String string2 = networkAuthenticationRequired.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof NetworkAuthenticationRequired;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "NetworkAuthenticationRequired";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public NetworkAuthenticationRequired copy(String msg) {
            return new NetworkAuthenticationRequired(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class NotAcceptable
    extends HttpError
    implements Product {
        private final String msg;

        public static NotAcceptable apply(String string) {
            return HttpError$NotAcceptable$.MODULE$.apply(string);
        }

        public static NotAcceptable fromProduct(Product product) {
            return HttpError$NotAcceptable$.MODULE$.fromProduct(product);
        }

        public static NotAcceptable unapply(NotAcceptable notAcceptable) {
            return HttpError$NotAcceptable$.MODULE$.unapply(notAcceptable);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$NotAcceptable$.MODULE$.$lessinit$greater$default$1();
        }

        public NotAcceptable(String msg) {
            this.msg = msg;
            super(Status$NotAcceptable$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NotAcceptable)) return false;
            NotAcceptable notAcceptable = (NotAcceptable)object;
            String string = this.msg();
            String string2 = notAcceptable.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof NotAcceptable;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "NotAcceptable";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public NotAcceptable copy(String msg) {
            return new NotAcceptable(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class NotExtended
    extends HttpError
    implements Product {
        private final String msg;

        public static NotExtended apply(String string) {
            return HttpError$NotExtended$.MODULE$.apply(string);
        }

        public static NotExtended fromProduct(Product product) {
            return HttpError$NotExtended$.MODULE$.fromProduct(product);
        }

        public static NotExtended unapply(NotExtended notExtended) {
            return HttpError$NotExtended$.MODULE$.unapply(notExtended);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$NotExtended$.MODULE$.$lessinit$greater$default$1();
        }

        public NotExtended(String msg) {
            this.msg = msg;
            super(Status$NotExtended$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NotExtended)) return false;
            NotExtended notExtended = (NotExtended)object;
            String string = this.msg();
            String string2 = notExtended.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof NotExtended;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "NotExtended";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public NotExtended copy(String msg) {
            return new NotExtended(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class NotFound
    extends HttpError
    implements Product {
        private final Path path;

        public static NotFound apply(Path path) {
            return HttpError$NotFound$.MODULE$.apply(path);
        }

        public static NotFound fromProduct(Product product) {
            return HttpError$NotFound$.MODULE$.fromProduct(product);
        }

        public static NotFound unapply(NotFound notFound) {
            return HttpError$NotFound$.MODULE$.unapply(notFound);
        }

        public NotFound(Path path) {
            this.path = path;
            super(Status$NotFound$.MODULE$, new StringBuilder(50).append("The requested URI \"").append(path.encode()).append("\" was not found on this server\n").toString());
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NotFound)) return false;
            NotFound notFound = (NotFound)object;
            Path path = this.path();
            Path path2 = notFound.path();
            if (path != null) {
                if (!((Object)path).equals(path2)) return false;
                return true;
            }
            if (path2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof NotFound;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "NotFound";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "path";
        }

        public Path path() {
            return this.path;
        }

        public NotFound copy(Path path) {
            return new NotFound(path);
        }

        public Path copy$default$1() {
            return this.path();
        }

        public Path _1() {
            return this.path();
        }
    }

    public static final class NotImplemented
    extends HttpError
    implements Product {
        private final String msg;

        public static NotImplemented apply(String string) {
            return HttpError$NotImplemented$.MODULE$.apply(string);
        }

        public static NotImplemented fromProduct(Product product) {
            return HttpError$NotImplemented$.MODULE$.fromProduct(product);
        }

        public static NotImplemented unapply(NotImplemented notImplemented) {
            return HttpError$NotImplemented$.MODULE$.unapply(notImplemented);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$NotImplemented$.MODULE$.$lessinit$greater$default$1();
        }

        public NotImplemented(String msg) {
            this.msg = msg;
            super(Status$NotImplemented$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NotImplemented)) return false;
            NotImplemented notImplemented = (NotImplemented)object;
            String string = this.msg();
            String string2 = notImplemented.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof NotImplemented;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "NotImplemented";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public NotImplemented copy(String msg) {
            return new NotImplemented(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class PaymentRequired
    extends HttpError
    implements Product {
        private final String msg;

        public static PaymentRequired apply(String string) {
            return HttpError$PaymentRequired$.MODULE$.apply(string);
        }

        public static PaymentRequired fromProduct(Product product) {
            return HttpError$PaymentRequired$.MODULE$.fromProduct(product);
        }

        public static PaymentRequired unapply(PaymentRequired paymentRequired) {
            return HttpError$PaymentRequired$.MODULE$.unapply(paymentRequired);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$PaymentRequired$.MODULE$.$lessinit$greater$default$1();
        }

        public PaymentRequired(String msg) {
            this.msg = msg;
            super(Status$PaymentRequired$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PaymentRequired)) return false;
            PaymentRequired paymentRequired = (PaymentRequired)object;
            String string = this.msg();
            String string2 = paymentRequired.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof PaymentRequired;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "PaymentRequired";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public PaymentRequired copy(String msg) {
            return new PaymentRequired(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class PreconditionFailed
    extends HttpError
    implements Product {
        private final String msg;

        public static PreconditionFailed apply(String string) {
            return HttpError$PreconditionFailed$.MODULE$.apply(string);
        }

        public static PreconditionFailed fromProduct(Product product) {
            return HttpError$PreconditionFailed$.MODULE$.fromProduct(product);
        }

        public static PreconditionFailed unapply(PreconditionFailed preconditionFailed) {
            return HttpError$PreconditionFailed$.MODULE$.unapply(preconditionFailed);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$PreconditionFailed$.MODULE$.$lessinit$greater$default$1();
        }

        public PreconditionFailed(String msg) {
            this.msg = msg;
            super(Status$PreconditionFailed$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PreconditionFailed)) return false;
            PreconditionFailed preconditionFailed = (PreconditionFailed)object;
            String string = this.msg();
            String string2 = preconditionFailed.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof PreconditionFailed;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "PreconditionFailed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public PreconditionFailed copy(String msg) {
            return new PreconditionFailed(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class PreconditionRequired
    extends HttpError
    implements Product {
        private final String msg;

        public static PreconditionRequired apply(String string) {
            return HttpError$PreconditionRequired$.MODULE$.apply(string);
        }

        public static PreconditionRequired fromProduct(Product product) {
            return HttpError$PreconditionRequired$.MODULE$.fromProduct(product);
        }

        public static PreconditionRequired unapply(PreconditionRequired preconditionRequired) {
            return HttpError$PreconditionRequired$.MODULE$.unapply(preconditionRequired);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$PreconditionRequired$.MODULE$.$lessinit$greater$default$1();
        }

        public PreconditionRequired(String msg) {
            this.msg = msg;
            super(Status$PreconditionRequired$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PreconditionRequired)) return false;
            PreconditionRequired preconditionRequired = (PreconditionRequired)object;
            String string = this.msg();
            String string2 = preconditionRequired.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof PreconditionRequired;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "PreconditionRequired";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public PreconditionRequired copy(String msg) {
            return new PreconditionRequired(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class ProxyAuthenticationRequired
    extends HttpError
    implements Product {
        private final String msg;

        public static ProxyAuthenticationRequired apply(String string) {
            return HttpError$ProxyAuthenticationRequired$.MODULE$.apply(string);
        }

        public static ProxyAuthenticationRequired fromProduct(Product product) {
            return HttpError$ProxyAuthenticationRequired$.MODULE$.fromProduct(product);
        }

        public static ProxyAuthenticationRequired unapply(ProxyAuthenticationRequired proxyAuthenticationRequired) {
            return HttpError$ProxyAuthenticationRequired$.MODULE$.unapply(proxyAuthenticationRequired);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$ProxyAuthenticationRequired$.MODULE$.$lessinit$greater$default$1();
        }

        public ProxyAuthenticationRequired(String msg) {
            this.msg = msg;
            super(Status$ProxyAuthenticationRequired$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ProxyAuthenticationRequired)) return false;
            ProxyAuthenticationRequired proxyAuthenticationRequired = (ProxyAuthenticationRequired)object;
            String string = this.msg();
            String string2 = proxyAuthenticationRequired.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof ProxyAuthenticationRequired;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ProxyAuthenticationRequired";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public ProxyAuthenticationRequired copy(String msg) {
            return new ProxyAuthenticationRequired(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class RequestEntityTooLarge
    extends HttpError
    implements Product {
        private final String msg;

        public static RequestEntityTooLarge apply(String string) {
            return HttpError$RequestEntityTooLarge$.MODULE$.apply(string);
        }

        public static RequestEntityTooLarge fromProduct(Product product) {
            return HttpError$RequestEntityTooLarge$.MODULE$.fromProduct(product);
        }

        public static RequestEntityTooLarge unapply(RequestEntityTooLarge requestEntityTooLarge) {
            return HttpError$RequestEntityTooLarge$.MODULE$.unapply(requestEntityTooLarge);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$RequestEntityTooLarge$.MODULE$.$lessinit$greater$default$1();
        }

        public RequestEntityTooLarge(String msg) {
            this.msg = msg;
            super(Status$RequestEntityTooLarge$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RequestEntityTooLarge)) return false;
            RequestEntityTooLarge requestEntityTooLarge = (RequestEntityTooLarge)object;
            String string = this.msg();
            String string2 = requestEntityTooLarge.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof RequestEntityTooLarge;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RequestEntityTooLarge";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public RequestEntityTooLarge copy(String msg) {
            return new RequestEntityTooLarge(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class RequestHeaderFieldsTooLarge
    extends HttpError
    implements Product {
        private final String msg;

        public static RequestHeaderFieldsTooLarge apply(String string) {
            return HttpError$RequestHeaderFieldsTooLarge$.MODULE$.apply(string);
        }

        public static RequestHeaderFieldsTooLarge fromProduct(Product product) {
            return HttpError$RequestHeaderFieldsTooLarge$.MODULE$.fromProduct(product);
        }

        public static RequestHeaderFieldsTooLarge unapply(RequestHeaderFieldsTooLarge requestHeaderFieldsTooLarge) {
            return HttpError$RequestHeaderFieldsTooLarge$.MODULE$.unapply(requestHeaderFieldsTooLarge);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$RequestHeaderFieldsTooLarge$.MODULE$.$lessinit$greater$default$1();
        }

        public RequestHeaderFieldsTooLarge(String msg) {
            this.msg = msg;
            super(Status$RequestHeaderFieldsTooLarge$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RequestHeaderFieldsTooLarge)) return false;
            RequestHeaderFieldsTooLarge requestHeaderFieldsTooLarge = (RequestHeaderFieldsTooLarge)object;
            String string = this.msg();
            String string2 = requestHeaderFieldsTooLarge.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof RequestHeaderFieldsTooLarge;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RequestHeaderFieldsTooLarge";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public RequestHeaderFieldsTooLarge copy(String msg) {
            return new RequestHeaderFieldsTooLarge(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class RequestTimeout
    extends HttpError
    implements Product {
        private final String msg;

        public static RequestTimeout apply(String string) {
            return HttpError$RequestTimeout$.MODULE$.apply(string);
        }

        public static RequestTimeout fromProduct(Product product) {
            return HttpError$RequestTimeout$.MODULE$.fromProduct(product);
        }

        public static RequestTimeout unapply(RequestTimeout requestTimeout) {
            return HttpError$RequestTimeout$.MODULE$.unapply(requestTimeout);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$RequestTimeout$.MODULE$.$lessinit$greater$default$1();
        }

        public RequestTimeout(String msg) {
            this.msg = msg;
            super(Status$RequestTimeout$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RequestTimeout)) return false;
            RequestTimeout requestTimeout = (RequestTimeout)object;
            String string = this.msg();
            String string2 = requestTimeout.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof RequestTimeout;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RequestTimeout";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public RequestTimeout copy(String msg) {
            return new RequestTimeout(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class RequestUriTooLong
    extends HttpError
    implements Product {
        private final String msg;

        public static RequestUriTooLong apply(String string) {
            return HttpError$RequestUriTooLong$.MODULE$.apply(string);
        }

        public static RequestUriTooLong fromProduct(Product product) {
            return HttpError$RequestUriTooLong$.MODULE$.fromProduct(product);
        }

        public static RequestUriTooLong unapply(RequestUriTooLong requestUriTooLong) {
            return HttpError$RequestUriTooLong$.MODULE$.unapply(requestUriTooLong);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$RequestUriTooLong$.MODULE$.$lessinit$greater$default$1();
        }

        public RequestUriTooLong(String msg) {
            this.msg = msg;
            super(Status$RequestUriTooLong$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RequestUriTooLong)) return false;
            RequestUriTooLong requestUriTooLong = (RequestUriTooLong)object;
            String string = this.msg();
            String string2 = requestUriTooLong.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof RequestUriTooLong;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RequestUriTooLong";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public RequestUriTooLong copy(String msg) {
            return new RequestUriTooLong(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class RequestedRangeNotSatisfiable
    extends HttpError
    implements Product {
        private final String msg;

        public static RequestedRangeNotSatisfiable apply(String string) {
            return HttpError$RequestedRangeNotSatisfiable$.MODULE$.apply(string);
        }

        public static RequestedRangeNotSatisfiable fromProduct(Product product) {
            return HttpError$RequestedRangeNotSatisfiable$.MODULE$.fromProduct(product);
        }

        public static RequestedRangeNotSatisfiable unapply(RequestedRangeNotSatisfiable requestedRangeNotSatisfiable) {
            return HttpError$RequestedRangeNotSatisfiable$.MODULE$.unapply(requestedRangeNotSatisfiable);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$RequestedRangeNotSatisfiable$.MODULE$.$lessinit$greater$default$1();
        }

        public RequestedRangeNotSatisfiable(String msg) {
            this.msg = msg;
            super(Status$RequestedRangeNotSatisfiable$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RequestedRangeNotSatisfiable)) return false;
            RequestedRangeNotSatisfiable requestedRangeNotSatisfiable = (RequestedRangeNotSatisfiable)object;
            String string = this.msg();
            String string2 = requestedRangeNotSatisfiable.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof RequestedRangeNotSatisfiable;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RequestedRangeNotSatisfiable";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public RequestedRangeNotSatisfiable copy(String msg) {
            return new RequestedRangeNotSatisfiable(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class ServiceUnavailable
    extends HttpError
    implements Product {
        private final String msg;

        public static ServiceUnavailable apply(String string) {
            return HttpError$ServiceUnavailable$.MODULE$.apply(string);
        }

        public static ServiceUnavailable fromProduct(Product product) {
            return HttpError$ServiceUnavailable$.MODULE$.fromProduct(product);
        }

        public static ServiceUnavailable unapply(ServiceUnavailable serviceUnavailable) {
            return HttpError$ServiceUnavailable$.MODULE$.unapply(serviceUnavailable);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$ServiceUnavailable$.MODULE$.$lessinit$greater$default$1();
        }

        public ServiceUnavailable(String msg) {
            this.msg = msg;
            super(Status$ServiceUnavailable$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ServiceUnavailable)) return false;
            ServiceUnavailable serviceUnavailable = (ServiceUnavailable)object;
            String string = this.msg();
            String string2 = serviceUnavailable.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof ServiceUnavailable;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ServiceUnavailable";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public ServiceUnavailable copy(String msg) {
            return new ServiceUnavailable(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class TooManyRequests
    extends HttpError
    implements Product {
        private final String msg;

        public static TooManyRequests apply(String string) {
            return HttpError$TooManyRequests$.MODULE$.apply(string);
        }

        public static TooManyRequests fromProduct(Product product) {
            return HttpError$TooManyRequests$.MODULE$.fromProduct(product);
        }

        public static TooManyRequests unapply(TooManyRequests tooManyRequests) {
            return HttpError$TooManyRequests$.MODULE$.unapply(tooManyRequests);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$TooManyRequests$.MODULE$.$lessinit$greater$default$1();
        }

        public TooManyRequests(String msg) {
            this.msg = msg;
            super(Status$TooManyRequests$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TooManyRequests)) return false;
            TooManyRequests tooManyRequests = (TooManyRequests)object;
            String string = this.msg();
            String string2 = tooManyRequests.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof TooManyRequests;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "TooManyRequests";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public TooManyRequests copy(String msg) {
            return new TooManyRequests(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class Unauthorized
    extends HttpError
    implements Product {
        private final String msg;

        public static Unauthorized apply(String string) {
            return HttpError$Unauthorized$.MODULE$.apply(string);
        }

        public static Unauthorized fromProduct(Product product) {
            return HttpError$Unauthorized$.MODULE$.fromProduct(product);
        }

        public static Unauthorized unapply(Unauthorized unauthorized) {
            return HttpError$Unauthorized$.MODULE$.unapply(unauthorized);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$Unauthorized$.MODULE$.$lessinit$greater$default$1();
        }

        public Unauthorized(String msg) {
            this.msg = msg;
            super(Status$Unauthorized$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Unauthorized)) return false;
            Unauthorized unauthorized = (Unauthorized)object;
            String string = this.msg();
            String string2 = unauthorized.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Unauthorized;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Unauthorized";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public Unauthorized copy(String msg) {
            return new Unauthorized(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class UnorderedCollection
    extends HttpError
    implements Product {
        private final String msg;

        public static UnorderedCollection apply(String string) {
            return HttpError$UnorderedCollection$.MODULE$.apply(string);
        }

        public static UnorderedCollection fromProduct(Product product) {
            return HttpError$UnorderedCollection$.MODULE$.fromProduct(product);
        }

        public static UnorderedCollection unapply(UnorderedCollection unorderedCollection) {
            return HttpError$UnorderedCollection$.MODULE$.unapply(unorderedCollection);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$UnorderedCollection$.MODULE$.$lessinit$greater$default$1();
        }

        public UnorderedCollection(String msg) {
            this.msg = msg;
            super(Status$UnorderedCollection$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UnorderedCollection)) return false;
            UnorderedCollection unorderedCollection = (UnorderedCollection)object;
            String string = this.msg();
            String string2 = unorderedCollection.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof UnorderedCollection;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "UnorderedCollection";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public UnorderedCollection copy(String msg) {
            return new UnorderedCollection(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class UnprocessableEntity
    extends HttpError
    implements Product {
        private final String msg;

        public static UnprocessableEntity apply(String string) {
            return HttpError$UnprocessableEntity$.MODULE$.apply(string);
        }

        public static UnprocessableEntity fromProduct(Product product) {
            return HttpError$UnprocessableEntity$.MODULE$.fromProduct(product);
        }

        public static UnprocessableEntity unapply(UnprocessableEntity unprocessableEntity) {
            return HttpError$UnprocessableEntity$.MODULE$.unapply(unprocessableEntity);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$UnprocessableEntity$.MODULE$.$lessinit$greater$default$1();
        }

        public UnprocessableEntity(String msg) {
            this.msg = msg;
            super(Status$UnprocessableEntity$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UnprocessableEntity)) return false;
            UnprocessableEntity unprocessableEntity = (UnprocessableEntity)object;
            String string = this.msg();
            String string2 = unprocessableEntity.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof UnprocessableEntity;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "UnprocessableEntity";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public UnprocessableEntity copy(String msg) {
            return new UnprocessableEntity(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class UnsupportedMediaType
    extends HttpError
    implements Product {
        private final String msg;

        public static UnsupportedMediaType apply(String string) {
            return HttpError$UnsupportedMediaType$.MODULE$.apply(string);
        }

        public static UnsupportedMediaType fromProduct(Product product) {
            return HttpError$UnsupportedMediaType$.MODULE$.fromProduct(product);
        }

        public static UnsupportedMediaType unapply(UnsupportedMediaType unsupportedMediaType) {
            return HttpError$UnsupportedMediaType$.MODULE$.unapply(unsupportedMediaType);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$UnsupportedMediaType$.MODULE$.$lessinit$greater$default$1();
        }

        public UnsupportedMediaType(String msg) {
            this.msg = msg;
            super(Status$UnsupportedMediaType$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UnsupportedMediaType)) return false;
            UnsupportedMediaType unsupportedMediaType = (UnsupportedMediaType)object;
            String string = this.msg();
            String string2 = unsupportedMediaType.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof UnsupportedMediaType;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "UnsupportedMediaType";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public UnsupportedMediaType copy(String msg) {
            return new UnsupportedMediaType(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class UpgradeRequired
    extends HttpError
    implements Product {
        private final String msg;

        public static UpgradeRequired apply(String string) {
            return HttpError$UpgradeRequired$.MODULE$.apply(string);
        }

        public static UpgradeRequired fromProduct(Product product) {
            return HttpError$UpgradeRequired$.MODULE$.fromProduct(product);
        }

        public static UpgradeRequired unapply(UpgradeRequired upgradeRequired) {
            return HttpError$UpgradeRequired$.MODULE$.unapply(upgradeRequired);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$UpgradeRequired$.MODULE$.$lessinit$greater$default$1();
        }

        public UpgradeRequired(String msg) {
            this.msg = msg;
            super(Status$UpgradeRequired$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UpgradeRequired)) return false;
            UpgradeRequired upgradeRequired = (UpgradeRequired)object;
            String string = this.msg();
            String string2 = upgradeRequired.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof UpgradeRequired;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "UpgradeRequired";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public UpgradeRequired copy(String msg) {
            return new UpgradeRequired(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class VariantAlsoNegotiates
    extends HttpError
    implements Product {
        private final String msg;

        public static VariantAlsoNegotiates apply(String string) {
            return HttpError$VariantAlsoNegotiates$.MODULE$.apply(string);
        }

        public static VariantAlsoNegotiates fromProduct(Product product) {
            return HttpError$VariantAlsoNegotiates$.MODULE$.fromProduct(product);
        }

        public static VariantAlsoNegotiates unapply(VariantAlsoNegotiates variantAlsoNegotiates) {
            return HttpError$VariantAlsoNegotiates$.MODULE$.unapply(variantAlsoNegotiates);
        }

        public static String $lessinit$greater$default$1() {
            return HttpError$VariantAlsoNegotiates$.MODULE$.$lessinit$greater$default$1();
        }

        public VariantAlsoNegotiates(String msg) {
            this.msg = msg;
            super(Status$VariantAlsoNegotiates$.MODULE$, msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof VariantAlsoNegotiates)) return false;
            VariantAlsoNegotiates variantAlsoNegotiates = (VariantAlsoNegotiates)object;
            String string = this.msg();
            String string2 = variantAlsoNegotiates.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof VariantAlsoNegotiates;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "VariantAlsoNegotiates";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public VariantAlsoNegotiates copy(String msg) {
            return new VariantAlsoNegotiates(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }
}

