/*
 * Decompiled with CFR 0.152.
 */
package zhttp.service.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.codec.http.HttpServerKeepAliveHandler;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Serializable;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import zhttp.logging.LogLevel;
import zhttp.service.HttpRuntime;
import zhttp.service.Server;
import zhttp.service.logging.NettyLoggerFactory$;
import zhttp.service.package$;
import zhttp.service.server.LogLevelTransform$;
import zhttp.service.server.OptionalSSLHandler;
import zhttp.service.server.ServerChannelInitializer$;

@ChannelHandler.Sharable
public final class ServerChannelInitializer<R>
extends ChannelInitializer<Channel>
implements Product,
Serializable {
    private final HttpRuntime zExec;
    private final Server.Config cfg;
    private final ChannelHandler reqHandler;

    public static <R> ServerChannelInitializer<R> apply(HttpRuntime<R> httpRuntime, Server.Config<R, Throwable> config, ChannelHandler channelHandler) {
        return ServerChannelInitializer$.MODULE$.apply(httpRuntime, config, channelHandler);
    }

    public static ServerChannelInitializer<?> fromProduct(Product product) {
        return ServerChannelInitializer$.MODULE$.fromProduct(product);
    }

    public static <R> ServerChannelInitializer<R> unapply(ServerChannelInitializer<R> serverChannelInitializer) {
        return ServerChannelInitializer$.MODULE$.unapply(serverChannelInitializer);
    }

    public ServerChannelInitializer(HttpRuntime<R> zExec, Server.Config<R, Throwable> cfg, ChannelHandler reqHandler) {
        this.zExec = zExec;
        this.cfg = cfg;
        this.reqHandler = reqHandler;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ServerChannelInitializer)) return false;
        ServerChannelInitializer serverChannelInitializer = (ServerChannelInitializer)object;
        HttpRuntime<R> httpRuntime = this.zExec();
        HttpRuntime<R> httpRuntime2 = serverChannelInitializer.zExec();
        if (httpRuntime == null) {
            if (httpRuntime2 != null) {
                return false;
            }
        } else if (!httpRuntime.equals(httpRuntime2)) return false;
        Server.Config<R, Throwable> config = this.cfg();
        Server.Config<R, Throwable> config2 = serverChannelInitializer.cfg();
        if (config == null) {
            if (config2 != null) {
                return false;
            }
        } else if (!((Object)config).equals(config2)) return false;
        ChannelHandler channelHandler = this.reqHandler();
        ChannelHandler channelHandler2 = serverChannelInitializer.reqHandler();
        if (channelHandler == null) {
            if (channelHandler2 == null) return true;
            return false;
        } else {
            if (!channelHandler.equals(channelHandler2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ServerChannelInitializer;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "ServerChannelInitializer";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "zExec";
                break;
            }
            case 1: {
                string = "cfg";
                break;
            }
            case 2: {
                string = "reqHandler";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public HttpRuntime<R> zExec() {
        return this.zExec;
    }

    public Server.Config<R, Throwable> cfg() {
        return this.cfg;
    }

    public ChannelHandler reqHandler() {
        return this.reqHandler;
    }

    public void initChannel(Channel channel) {
        SslContext sslctx;
        ChannelPipeline pipeline = channel.pipeline();
        SslContext sslContext = sslctx = this.cfg().sslOption() == null ? null : this.cfg().sslOption().sslContext();
        if (sslctx != null) {
            pipeline.addFirst(package$.MODULE$.SSL_HANDLER(), (ChannelHandler)new OptionalSSLHandler(sslctx, this.cfg().sslOption().httpBehaviour(), this.cfg()));
        }
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(4096, 8192, 8192, false));
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        if (BoxesRunTime.unboxToBoolean((Object)this.cfg().requestDecompression()._1())) {
            pipeline.addLast(package$.MODULE$.HTTP_REQUEST_DECOMPRESSION(), (ChannelHandler)new HttpContentDecompressor(BoxesRunTime.unboxToBoolean((Object)this.cfg().requestDecompression()._2())));
        }
        if (this.cfg().useAggregator()) {
            pipeline.addLast(package$.MODULE$.HTTP_OBJECT_AGGREGATOR(), (ChannelHandler)new HttpObjectAggregator(this.cfg().objectAggregator()));
        }
        if (this.cfg().acceptContinue()) {
            pipeline.addLast(package$.MODULE$.HTTP_SERVER_EXPECT_CONTINUE(), (ChannelHandler)new HttpServerExpectContinueHandler());
        }
        if (this.cfg().keepAlive()) {
            pipeline.addLast(package$.MODULE$.HTTP_KEEPALIVE_HANDLER(), (ChannelHandler)new HttpServerKeepAliveHandler());
        }
        if (this.cfg().flowControl()) {
            pipeline.addLast(package$.MODULE$.FLOW_CONTROL_HANDLER(), (ChannelHandler)new FlowControlHandler());
        }
        if (this.cfg().consolidateFlush()) {
            pipeline.addLast(package$.MODULE$.HTTP_SERVER_FLUSH_CONSOLIDATION(), (ChannelHandler)new FlushConsolidationHandler());
        }
        if (package$.MODULE$.EnableNettyLogging()) {
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)NettyLoggerFactory$.MODULE$.apply(ServerChannelInitializer$.zhttp$service$server$ServerChannelInitializer$$$log));
            pipeline.addLast(package$.MODULE$.LOW_LEVEL_LOGGING(), (ChannelHandler)new LoggingHandler(LogLevelTransform$.MODULE$.LogLevelWrapper((LogLevel)LogLevel.Debug$.MODULE$).toNettyLogLevel()));
        }
        pipeline.addLast(package$.MODULE$.HTTP_REQUEST_HANDLER(), this.reqHandler());
        if (this.cfg().channelInitializer() != null) {
            this.cfg().channelInitializer().apply((Object)pipeline);
        }
    }

    public <R> ServerChannelInitializer<R> copy(HttpRuntime<R> zExec, Server.Config<R, Throwable> cfg, ChannelHandler reqHandler) {
        return new ServerChannelInitializer<R>(zExec, cfg, reqHandler);
    }

    public <R> HttpRuntime<R> copy$default$1() {
        return this.zExec();
    }

    public <R> Server.Config<R, Throwable> copy$default$2() {
        return this.cfg();
    }

    public <R> ChannelHandler copy$default$3() {
        return this.reqHandler();
    }

    public HttpRuntime<R> _1() {
        return this.zExec();
    }

    public Server.Config<R, Throwable> _2() {
        return this.cfg();
    }

    public ChannelHandler _3() {
        return this.reqHandler();
    }
}

