/*
 * Decompiled with CFR 0.152.
 */
package zhttp.http;

import io.netty.channel.ChannelHandlerContext;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.time.Duration;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.util.Either;
import zhttp.html.Html;
import zhttp.html.Template$;
import zhttp.http.HExit;
import zhttp.http.Headers;
import zhttp.http.Headers$;
import zhttp.http.Http;
import zhttp.http.Http$Attempt$;
import zhttp.http.Http$Chain$;
import zhttp.http.Http$Combine$;
import zhttp.http.Http$Die$;
import zhttp.http.Http$Empty$;
import zhttp.http.Http$Fail$;
import zhttp.http.Http$FoldHttp$;
import zhttp.http.Http$FromFunctionHExit$;
import zhttp.http.Http$FromHExit$;
import zhttp.http.Http$Identity$;
import zhttp.http.Http$PartialCollect$;
import zhttp.http.Http$PartialCollectHExit$;
import zhttp.http.Http$PartialCollectHttp$;
import zhttp.http.Http$PartialCollectZIO$;
import zhttp.http.Http$PartialContraFlatMap$;
import zhttp.http.Http$PartialFromFunction$;
import zhttp.http.Http$PartialFromFunctionHExit$;
import zhttp.http.Http$PartialFromFunctionZIO$;
import zhttp.http.Http$PartialFromOptionFunction$;
import zhttp.http.Http$Race$;
import zhttp.http.Http$RunMiddleware$;
import zhttp.http.Http$Succeed$;
import zhttp.http.Http$When$;
import zhttp.http.HttpData;
import zhttp.http.HttpData$;
import zhttp.http.HttpError;
import zhttp.http.HttpError$BadRequest$;
import zhttp.http.HttpError$Forbidden$;
import zhttp.http.HttpError$InternalServerError$;
import zhttp.http.HttpError$MethodNotAllowed$;
import zhttp.http.HttpError$NotFound$;
import zhttp.http.MediaType;
import zhttp.http.MediaType$;
import zhttp.http.Request;
import zhttp.http.Response;
import zhttp.http.Response$;
import zhttp.http.Status;
import zhttp.http.Status$Ok$;
import zhttp.http.Status$RequestEntityTooLarge$;
import zhttp.http.Status$RequestTimeout$;
import zhttp.http.package$;
import zio.ZEnvironment;
import zio.ZIO;
import zio.ZIO$;
import zio.stream.ZStream;

public final class Http$
implements Mirror.Sum,
Serializable {
    public static final Http$PartialCollectZIO$ PartialCollectZIO;
    public static final Http$PartialCollect$ PartialCollect;
    public static final Http$PartialCollectHttp$ PartialCollectHttp;
    public static final Http$PartialCollectHExit$ PartialCollectHExit;
    public static final Http$PartialContraFlatMap$ PartialContraFlatMap;
    public static final Http$PartialFromOptionFunction$ PartialFromOptionFunction;
    public static final Http$PartialFromFunction$ PartialFromFunction;
    public static final Http$PartialFromFunctionZIO$ PartialFromFunctionZIO;
    public static final Http$PartialFromFunctionHExit$ PartialFromFunctionHExit;
    public static final Http$Succeed$ zhttp$http$Http$$$Succeed;
    public static final Http$Race$ zhttp$http$Http$$$Race;
    public static final Http$Fail$ zhttp$http$Http$$$Fail;
    public static final Http$Die$ zhttp$http$Http$$$Die;
    public static final Http$FromFunctionHExit$ zhttp$http$Http$$$FromFunctionHExit;
    public static final Http$Chain$ zhttp$http$Http$$$Chain;
    public static final Http$FoldHttp$ zhttp$http$Http$$$FoldHttp;
    public static final Http$RunMiddleware$ zhttp$http$Http$$$RunMiddleware;
    public static final Http$Attempt$ zhttp$http$Http$$$Attempt;
    public static final Http$Combine$ zhttp$http$Http$$$Combine;
    public static final Http$FromHExit$ zhttp$http$Http$$$FromHExit;
    public static final Http$When$ zhttp$http$Http$$$When;
    public static final Http$Empty$ zhttp$http$Http$$$Empty;
    public static final Http$Identity$ zhttp$http$Http$$$Identity;
    public static final Http$ MODULE$;

    private Http$() {
    }

    static {
        MODULE$ = new Http$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Http$.class);
    }

    public final <R, E> Http.HttpAppSyntax<R, E> HttpAppSyntax(Http<R, E, Request, Response> http) {
        return new Http.HttpAppSyntax<R, E>(http);
    }

    public <B> Http<Object, Nothing$, Object, B> apply(B b) {
        return this.succeed(b);
    }

    public <A> Http<Object, Throwable, Object, A> attempt(Function0<A> a) {
        return Http$Attempt$.MODULE$.apply(a);
    }

    public Http<Object, Nothing$, Request, Response> badRequest(String msg) {
        return this.error(HttpError$BadRequest$.MODULE$.apply(msg));
    }

    public <A> BoxedUnit collect() {
        return Http$PartialCollect$.MODULE$.apply(BoxedUnit.UNIT);
    }

    public <A> BoxedUnit collectHExit() {
        return Http$PartialCollectHExit$.MODULE$.apply(BoxedUnit.UNIT);
    }

    public <A> BoxedUnit collectHttp() {
        return Http$PartialCollectHttp$.MODULE$.apply(BoxedUnit.UNIT);
    }

    public <A> BoxedUnit collectZIO() {
        return Http$PartialCollectZIO$.MODULE$.apply(BoxedUnit.UNIT);
    }

    public <R, E, A, B> Http<R, E, A, B> combine(Iterable<Http<R, E, A, B>> i) {
        return (Http)i.reduce((Function2 & Serializable)(_$25, _$26) -> _$25.defaultWith(_$26));
    }

    public Http<Object, Nothing$, Request, ChannelHandlerContext> context() {
        BoxedUnit boxedUnit = this.fromFunction();
        return Http$PartialFromFunction$.MODULE$.apply$extension(boxedUnit, (Function1 & Serializable)_$27 -> _$27.unsafeContext());
    }

    public Http<Object, Nothing$, Object, Nothing$> die(Throwable t) {
        return Http$Die$.MODULE$.apply(t);
    }

    public Http<Object, Nothing$, Object, Nothing$> dieMessage(Function0<String> message) {
        return this.die(new RuntimeException((String)message.apply()));
    }

    public Http<Object, Nothing$, Object, Nothing$> empty() {
        return Http$Empty$.MODULE$;
    }

    public Http<Object, Nothing$, Request, Response> error(HttpError cause) {
        return this.response(Response$.MODULE$.fromHttpError(cause));
    }

    public Http<Object, Nothing$, Request, Response> error(String msg) {
        return this.error(HttpError$InternalServerError$.MODULE$.apply(msg, HttpError$InternalServerError$.MODULE$.$lessinit$greater$default$2()));
    }

    public <E> Http<Object, E, Object, Nothing$> fail(E e) {
        return Http$Fail$.MODULE$.apply(e);
    }

    public <R, E, A, B> Http<R, E, A, B> flatten(Http<R, E, A, Http<R, E, A, B>> http) {
        return http.flatten($less$colon$less$.MODULE$.refl());
    }

    public <R, E, A, B> Http<R, E, A, B> flattenZIO(Http<R, E, A, ZIO<R, E, B>> http) {
        return http.flatMap((Function1 & Serializable)effect -> this.fromZIO((ZIO)effect));
    }

    public Http<Object, Nothing$, Request, Response> forbidden(String msg) {
        return this.error(HttpError$Forbidden$.MODULE$.apply(msg));
    }

    public Http<Object, Nothing$, Request, Response> fromData(HttpData data) {
        return this.response(Response$.MODULE$.apply(Response$.MODULE$.apply$default$1(), Response$.MODULE$.apply$default$2(), data));
    }

    public <E, A> Http<Object, E, Object, A> fromEither(Either<E, A> v) {
        return (Http)v.fold((Function1 & Serializable)e -> this.fail(e), (Function1 & Serializable)b -> this.succeed(b));
    }

    public Http<Object, Throwable, Request, Response> fromFile(Function0<File> file) {
        return this.fromFileZIO(ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$6 -> (File)file.apply(), (Object)"zhttp.http.Http$.fromFile.macro(Http.scala:821)"));
    }

    public <R> Http<R, Throwable, Request, Response> fromFileZIO(ZIO<R, Throwable, File> fileZIO) {
        ZIO response = fileZIO.flatMap((Function1 & Serializable)file -> ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$7 -> {
            Http<Object, Nothing$, Object, Object> http;
            if (file.isFile()) {
                None$ none$;
                Headers length = Headers$.MODULE$.contentLength(file.length());
                HttpData httpData = HttpData$.MODULE$.fromFile((Function0<File>)((Function0 & Serializable)() -> this.$anonfun$2(file)));
                Status status = Response$.MODULE$.apply$default$1();
                Response response = Response$.MODULE$.apply(status, length, httpData);
                String pathName = file.toPath().toString();
                int n = pathName.lastIndexOf(".");
                if (-1 == n) {
                    none$ = None$.MODULE$;
                } else {
                    int i = n;
                    none$ = Some$.MODULE$.apply((Object)pathName.substring(i + 1));
                }
                None$ ext2 = none$;
                http = this.succeed(ext2.flatMap((Function1 & Serializable)ext -> MediaType$.MODULE$.forFileExtension((String)ext)).fold(() -> this.$anonfun$1$$anonfun$1$$anonfun$2(response), (Function1 & Serializable)mediaType -> (Response)response.withMediaType((MediaType)mediaType)));
            } else {
                http = this.empty();
            }
            return http;
        }, (Object)"zhttp.http.Http$.fromFileZIO.response.macro(Http.scala:849)"), (Object)"zhttp.http.Http$.fromFileZIO.response.macro(Http.scala:850)");
        return this.fromZIO(response).flatten($less$colon$less$.MODULE$.refl());
    }

    public <A> BoxedUnit fromFunction() {
        return BoxedUnit.UNIT;
    }

    public <A> BoxedUnit fromFunctionHExit() {
        return BoxedUnit.UNIT;
    }

    public <A> BoxedUnit fromFunctionZIO() {
        return BoxedUnit.UNIT;
    }

    public <R, E, B> Http<R, E, Object, B> fromHExit(HExit<R, E, B> h) {
        return Http$FromHExit$.MODULE$.apply(h);
    }

    public <A> Http<Object, Option<Nothing$>, Object, A> fromOption(Option<A> v) {
        return (Http)v.fold(this::fromOption$$anonfun$1, (Function1 & Serializable)b -> this.succeed(b));
    }

    public <A> BoxedUnit fromOptionFunction() {
        return BoxedUnit.UNIT;
    }

    public Http<Object, Throwable, Request, Response> fromPath(String head, Seq<String> tail) {
        return this.fromFile((Function0<File>)((Function0 & Serializable)() -> this.fromPath$$anonfun$1(head, tail)));
    }

    public Http<Object, Throwable, Request, Response> fromResource(String path) {
        return this.getResource(path).flatMap((Function1 & Serializable)url -> this.fromFile((Function0<File>)((Function0 & Serializable)() -> this.fromResource$$anonfun$1$$anonfun$1(url))));
    }

    public <R> Http<R, Nothing$, Request, Response> fromStream(ZStream<R, Throwable, String> stream, Charset charset) {
        return this.fromZIO(ZIO$.MODULE$.environment((Object)"zhttp.http.Http$.fromStream.macro(Http.scala:906)").map((Function1 & Serializable)r -> this.fromData(HttpData$.MODULE$.fromStream((ZStream<Object, Throwable, CharSequence>)stream.provideEnvironment(() -> this.fromStream$$anonfun$1$$anonfun$1(r), (Object)"zhttp.http.Http$.fromStream.macro(Http.scala:906)"), charset)), (Object)"zhttp.http.Http$.fromStream.macro(Http.scala:906)")).flatten($less$colon$less$.MODULE$.refl());
    }

    public <R> Charset fromStream$default$2() {
        return package$.MODULE$.HTTP_CHARSET();
    }

    public <R> Http<R, Nothing$, Request, Response> fromStream(ZStream<R, Throwable, Object> stream) {
        return this.fromZIO(ZIO$.MODULE$.environment((Object)"zhttp.http.Http$.fromStream.macro(Http.scala:914)").map((Function1 & Serializable)r -> this.fromData(HttpData$.MODULE$.fromStream((ZStream<Object, Throwable, Object>)stream.provideEnvironment(() -> this.fromStream$$anonfun$2$$anonfun$1(r), (Object)"zhttp.http.Http$.fromStream.macro(Http.scala:914)"))), (Object)"zhttp.http.Http$.fromStream.macro(Http.scala:914)")).flatten($less$colon$less$.MODULE$.refl());
    }

    public <R, E, B> Http<R, E, Object, B> fromZIO(ZIO<R, E, B> effect) {
        BoxedUnit boxedUnit = this.fromFunctionZIO();
        return Http$PartialFromFunctionZIO$.MODULE$.apply$extension(boxedUnit, (Function1 & Serializable)_$28 -> effect);
    }

    public Http<Object, Throwable, Object, URL> getResource(String path) {
        return this.fromZIO(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$8 -> this.getClass().getClassLoader().getResource(path), (Object)"zhttp.http.Http$.getResource.macro(Http.scala:926)")).flatMap((Function1 & Serializable)resource -> resource == null ? this.empty() : this.succeed(resource));
    }

    public Http<Object, Throwable, Object, File> getResourceAsFile(String path) {
        return this.getResource(path).map((Function1 & Serializable)url -> new File(url.getPath()));
    }

    public Http<Object, Nothing$, Request, Response> html(Html view) {
        return this.response(Response$.MODULE$.html(view, Response$.MODULE$.html$default$2()));
    }

    public <A> Http<Object, Nothing$, A, A> identity() {
        return Http$Identity$.MODULE$;
    }

    public Http<Object, Nothing$, Request, Response> methodNotAllowed(String msg) {
        return this.error(HttpError$MethodNotAllowed$.MODULE$.apply(msg));
    }

    public Http<Object, Nothing$, Request, Response> notFound() {
        BoxedUnit boxedUnit = this.fromFunction();
        return Http$PartialFromFunction$.MODULE$.apply$extension(boxedUnit, (Function1 & Serializable)req -> this.error(HttpError$NotFound$.MODULE$.apply(req.url().path()))).flatten($less$colon$less$.MODULE$.refl());
    }

    public Http<Object, Nothing$, Request, Response> ok() {
        return this.status(Status$Ok$.MODULE$);
    }

    public Http<Object, IOException, Request, InetAddress> remoteAddress() {
        return this.context().flatMap((Function1 & Serializable)ctx -> {
            Http<Object, IOException, Object, Object> http;
            SocketAddress socketAddress = ctx.channel().remoteAddress();
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress m = (InetSocketAddress)socketAddress;
                http = this.succeed(m.getAddress());
            } else {
                http = this.fail(new IOException("Unable to get remote address"));
            }
            return http;
        });
    }

    public Http<Object, Nothing$, Object, Response> response(Response response) {
        return this.succeed(response);
    }

    public <R, E> Http<R, E, Request, Response> responseZIO(ZIO<R, E, Response> res) {
        return this.fromZIO(res);
    }

    public Http<Object, Nothing$, Request, Response> status(Status code) {
        return this.succeed(Response$.MODULE$.apply(code, Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3()));
    }

    public <B> Http<Object, Nothing$, Object, B> succeed(B b) {
        return Http$Succeed$.MODULE$.apply(b);
    }

    public Http<Object, Nothing$, Request, Response> template(CharSequence heading, Html view) {
        return this.response(Response$.MODULE$.html(Template$.MODULE$.container(heading, view), Response$.MODULE$.html$default$2()));
    }

    public Http<Object, Nothing$, Request, Response> text(CharSequence charSeq) {
        return this.succeed(Response$.MODULE$.text(charSeq));
    }

    public Http<Object, Nothing$, Request, Response> timeout(Duration duration) {
        return this.status(Status$RequestTimeout$.MODULE$).delay(duration);
    }

    public Http<Object, Nothing$, Request, Response> tooLarge() {
        return this.status(Status$RequestEntityTooLarge$.MODULE$);
    }

    public <R, E> Http<R, E, Request, Response> usingContext(Function1<ChannelHandlerContext, Http<R, E, Request, Response>> f) {
        return this.context().flatMap(f);
    }

    public int ordinal(Http<?, ?, ?, ?> x$0) {
        int n;
        Http<?, ?, ?, ?> http = x$0;
        if (http instanceof Http.Succeed) {
            n = 0;
        } else if (http instanceof Http.Race) {
            n = 1;
        } else if (http instanceof Http.Fail) {
            n = 2;
        } else if (http instanceof Http.Die) {
            n = 3;
        } else if (http instanceof Http.FromFunctionHExit) {
            n = 4;
        } else if (http instanceof Http.Chain) {
            n = 5;
        } else if (http instanceof Http.FoldHttp) {
            n = 6;
        } else if (http instanceof Http.RunMiddleware) {
            n = 7;
        } else if (http instanceof Http.Attempt) {
            n = 8;
        } else if (http instanceof Http.Combine) {
            n = 9;
        } else if (http instanceof Http.FromHExit) {
            n = 10;
        } else if (http instanceof Http.When) {
            n = 11;
        } else if (http == Http$Empty$.MODULE$) {
            n = 12;
        } else if (http == Http$Identity$.MODULE$) {
            n = 13;
        } else {
            throw new MatchError(http);
        }
        return n;
    }

    private final File $anonfun$2(File file$3) {
        return file$3;
    }

    private final Response $anonfun$1$$anonfun$1$$anonfun$2(Response response$1) {
        return response$1;
    }

    private final Http fromOption$$anonfun$1() {
        return this.fail(None$.MODULE$);
    }

    private final File fromPath$$anonfun$1(String head$1, Seq tail$1) {
        return Paths.get(head$1, (String[])Arrays$.MODULE$.seqToArray(tail$1, String.class)).toFile();
    }

    private final File fromResource$$anonfun$1$$anonfun$1(URL url$2) {
        return new File(url$2.getPath());
    }

    private final ZEnvironment fromStream$$anonfun$1$$anonfun$1(ZEnvironment r$4) {
        return r$4;
    }

    private final ZEnvironment fromStream$$anonfun$2$$anonfun$1(ZEnvironment r$5) {
        return r$5;
    }

    public static final /* synthetic */ Http zhttp$http$Http$PartialFromOptionFunction$$anon$5$$_$applyOrElse$$anonfun$1(Object b) {
        return MODULE$.succeed(b);
    }

    public static final /* synthetic */ ZIO zhttp$http$Http$PartialFromOptionFunction$$anon$5$$_$applyOrElse$$anonfun$2(Option x$1) {
        ZIO zIO;
        Option option = x$1;
        if (option instanceof Some) {
            Object error = ((Some)option).value();
            zIO = ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$9 -> MODULE$.fail(error), (Object)"zhttp.http.Http$.PartialFromOptionFunction.apply.macro(Http.scala:1059)");
        } else if (None$.MODULE$.equals(option)) {
            zIO = ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$10 -> MODULE$.empty(), (Object)"zhttp.http.Http$.PartialFromOptionFunction.apply.macro(Http.scala:1060)");
        } else {
            throw new MatchError((Object)option);
        }
        return zIO;
    }

    public static final /* synthetic */ ZIO zhttp$http$Http$PartialFromOptionFunction$$anon$5$$_$applyOrElse$$anonfun$3(Throwable defect) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$11 -> MODULE$.die(defect), (Object)"zhttp.http.Http$.PartialFromOptionFunction.apply.macro(Http.scala:1062)");
    }
}

